/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.configuration;

import com.fortify.configuration.BuildID;
import com.fortify.configuration.properties.FProperties;
import com.fortify.exceptions.FortifyCheckedException;
import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Localization;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.rules.RulepackManager;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.ConfigurationManager;
import com.fortify.util.FileUtil;
import com.fortify.util.SCARunner.SCAExec;
import com.fortify.util.SCARunner.SCAExecCommands;
import com.fortify.util.SCARunner.ScanSpecification;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SCAConfigurationUtil {
    static ILogger logger = MessageManager.getLogger(SCAConfigurationUtil.class);
    private static Properties scaProps;
    private static final String SHOW_RUNTIME = "-show-runtime-properties";
    public static final String CORE_RULES;
    public static final String CUSTOM_RULES;
    public static final String DEFAULT_TYPES;
    public static final String DEVINSPECT_EXE_JAR_PATH = "Core/lib/exe/sca-exe.jar";
    private static List extensions;
    private static String versionNumber;
    private static final String VERSION = "-version";
    private static final String SHOW_BUILDIDS = "-show-build-ids";
    private static final String defaultFileExtensions = "java,jsp,jspx,sql,cfm,php,pks,pkh,pkb,xml,config,properties,dll,exe,inc,asp,vbscript,js,ini,bas,cls,vbs";
    private static List<File> possibleSCAPaths;
    static final Pattern versionPattern;

    public static void setProperties(Properties props) {
        scaProps = props;
    }

    public static String getSCAProperty(String propertyName) {
        try {
            return SCAConfigurationUtil.getSCAProperties().getProperty(propertyName);
        }
        catch (FortifyException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error retrieving SCA Property defaulting to null" + e.getMessage());
            return null;
        }
    }

    public static String checkedGetSCAProperty(String propertyName) throws FortifyCheckedException {
        try {
            return SCAConfigurationUtil.getSCAProperties().getProperty(propertyName);
        }
        catch (FortifyException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error retrieving SCA Property defaulting to null" + e.getMessage());
            throw new FortifyCheckedException(e.getFortifyMessage());
        }
    }

    private static Properties getSCAProperties() {
        if (scaProps == null) {
            SCAConfigurationUtil.loadSCAProps();
        }
        return scaProps;
    }

    private static void loadSCAProps() {
        List<String> output = Collections.emptyList();
        try {
            output = SCAConfigurationUtil.runSCACommand(SHOW_RUNTIME);
        }
        finally {
            SCAConfigurationUtil.loadPropsFromList(output);
        }
    }

    private static List<String> runSCACommand(String arg) {
        String path = SCAConfigurationUtil.getSCAPath();
        if (!new File(path).exists()) {
            throw new FortifyException(new Message(4, Localization.getLocalString(258, new Object[0])));
        }
        ScanSpecification scanSpec = new ScanSpecification(path);
        scanSpec.addCommand(SCAExecCommands.INFO);
        scanSpec.setBuildId("SCARuntimeProperties");
        scanSpec.addInfoArgument(arg);
        SCAExec exec = new SCAExec(scanSpec);
        try {
            exec.run();
        }
        catch (Exception e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error communicating with SCA executable" + e.getMessage());
            throw new FortifyException(new Message(4, Localization.getLocalString(258, new Object[0])));
        }
        if (scanSpec.failed() || scanSpec.hasErrors()) {
            StringBuffer sb = new StringBuffer();
            for (String err : exec.getErrorList()) {
                sb.append(err);
            }
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error communicating with SCA executable: " + sb.toString());
            if (scanSpec.failed()) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error running SCA: " + exec.getReturnCode(), (Throwable)scanSpec.getException());
                throw new FortifyException(new Message(4, Localization.getLocalString(258, new Object[0])));
            }
        }
        return scanSpec.getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropsFromList(List<String> output) {
        scaProps = new Properties(SystemUtil.getProperties());
        StringBuffer sb = new StringBuffer();
        for (String line : output) {
            sb.append(line).append("\n");
        }
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(StringUtil.getBytes(sb.toString()));
            scaProps.load(bais);
        }
        catch (IOException e) {
            try {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error closing constructed inputstream", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(bais);
                throw throwable;
            }
            FileUtil.close(bais);
        }
        FileUtil.close(bais);
    }

    public static List findSupportedExtensions() {
        if (extensions == null) {
            String extensionsString = SCAConfigurationUtil.getSCAProperty(DEFAULT_TYPES);
            if (extensionsString == null) {
                extensionsString = defaultFileExtensions;
            }
            extensions = StringUtil.split(extensionsString, ',');
        }
        return extensions;
    }

    private static void initPossibleSCAPaths() {
        possibleSCAPaths.add(new File(SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT), "../../../../bin"));
        possibleSCAPaths.add(new File(SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT), "bin"));
        String osRelativePath = "";
        if (SystemUtil.isWindows()) {
            String path;
            String progFiles3264;
            String path2;
            String progFiles;
            String path3;
            String progFiles86 = System.getenv("ProgramFiles(x86)");
            if (progFiles86 != null && FileUtil.isExistingDirectory(path3 = new File(progFiles86, "Fortify").getAbsolutePath())) {
                osRelativePath = path3;
            }
            if ((progFiles = System.getenv("ProgramFiles")) != null && FileUtil.isExistingDirectory(path2 = new File(progFiles, "Fortify").getAbsolutePath())) {
                osRelativePath = path2;
            }
            if ((progFiles3264 = System.getenv("ProgramW6432")) != null && FileUtil.isExistingDirectory(path = new File(progFiles3264, "Fortify").getAbsolutePath())) {
                osRelativePath = path;
            }
        } else if (SystemUtil.isLinux()) {
            String home;
            String userName = System.getProperty("user.name");
            if (!StringUtil.isEmpty(userName) && userName.equals("root")) {
                SCAConfigurationUtil.findPossibleSCAPaths("/opt/Fortify");
            }
            if (!StringUtil.isEmpty(home = System.getProperty("user.home"))) {
                osRelativePath = home + "/Fortify";
            }
        } else if (SystemUtil.isMacos()) {
            osRelativePath = "/Applications/Fortify";
        }
        if (!StringUtil.isEmpty(osRelativePath)) {
            SCAConfigurationUtil.findPossibleSCAPaths(osRelativePath);
        }
    }

    private static void findPossibleSCAPaths(String parentLocation) {
        String toolsVersion = "";
        String installPath = SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT);
        if (installPath != null) {
            File instDir = new File(installPath);
            try {
                installPath = instDir.getCanonicalPath();
            }
            catch (IOException ioe) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG_VERBOSE, "IOException creating canonical path for : " + installPath);
            }
            Matcher matcher = versionPattern.matcher(installPath);
            if (matcher.find()) {
                toolsVersion = matcher.group(1);
                possibleSCAPaths.add(new File(FileUtil.path(parentLocation, "Fortify_SCA_and_Apps_" + toolsVersion, "bin")));
                possibleSCAPaths.add(new File(FileUtil.path(parentLocation, "Fortify_SCA_" + toolsVersion, "bin")));
            }
        }
    }

    public static String getSCAPath() {
        boolean executableExists;
        String sourceAnalyzer = "sourceanalyzer" + (SystemUtil.isWindows() ? ".exe" : "");
        FProperties props = FProperties.loadUserPersitedProps("fortify.properties");
        String exec = props.getProperty(CommonPropertyKeys.PK_SCA_EXECUTABLE_PATH.key, "");
        File executable = exec.endsWith(sourceAnalyzer) || SCAConfigurationUtil.isDevInspect(exec) ? new File(exec) : new File(exec, sourceAnalyzer);
        if (possibleSCAPaths.isEmpty()) {
            SCAConfigurationUtil.initPossibleSCAPaths();
        }
        if (!(executableExists = executable.exists())) {
            File devInspectJar;
            File base;
            Iterator<File> iterator = possibleSCAPaths.iterator();
            while (iterator.hasNext() && !(executableExists = (executable = new File(base = iterator.next(), sourceAnalyzer)).exists())) {
            }
            if (!executableExists && (devInspectJar = new File(SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT), DEVINSPECT_EXE_JAR_PATH)).exists()) {
                executable = devInspectJar;
            }
        }
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Using SCA Executable: " + executable.getAbsolutePath());
        return executable.getAbsolutePath();
    }

    public static String getJavaExecPath() {
        FProperties props;
        String exec = SystemUtil.getProperty(CommonPropertyKeys.PK_JAVA);
        if (StringUtil.isEmpty(exec) && !StringUtil.isEmpty(exec = (props = FProperties.loadUserPersitedProps("fortify.properties")).getProperty(CommonPropertyKeys.PK_JAVA.key, ""))) {
            SystemUtil.getProperties().setProperty(CommonPropertyKeys.PK_JAVA.key, exec);
        }
        return exec;
    }

    public static void setJavaExecPath(String absolutePath) {
        FProperties props = FProperties.loadUserPersitedProps("fortify.properties");
        props.setProperty(CommonPropertyKeys.PK_JAVA.key, absolutePath);
        SystemUtil.getProperties().setProperty(CommonPropertyKeys.PK_JAVA.key, absolutePath);
    }

    public static boolean isDevInspect(String scaExecutable) {
        return FileUtil.normalizeDirectorySeperators(scaExecutable).endsWith(DEVINSPECT_EXE_JAR_PATH);
    }

    public static void setSCAPath(String absolutePath) {
        SystemUtil.getProperties().put(CommonPropertyKeys.PK_SCA_EXECUTABLE_PATH.key, absolutePath);
        FProperties fprops = FProperties.loadUserPersitedProps("fortify.properties");
        fprops.setProperty(CommonPropertyKeys.PK_SCA_EXECUTABLE_PATH.key, absolutePath);
        SCAConfigurationUtil.clearCachedProperties();
        SCAConfigurationUtil.reloadRelativeManagers();
    }

    public static String getVersion() {
        if (versionNumber == null) {
            try {
                List<String> res = SCAConfigurationUtil.runSCACommand(VERSION);
                versionNumber = res.isEmpty() ? Localization.getLocalString(259, new Object[0]) : res.get(0);
            }
            catch (FortifyException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error communicating", (Throwable)e);
                versionNumber = Localization.getLocalString(259, new Object[0]);
            }
        }
        return versionNumber;
    }

    public static List<BuildID> getExistingBuildIds() {
        List<String> ids = SCAConfigurationUtil.runSCACommand(SHOW_BUILDIDS);
        ArrayList<BuildID> validLabels = new ArrayList<BuildID>();
        BuildID bid = null;
        for (String possibleId : ids) {
            if (possibleId.length() == 0) continue;
            if (Character.isWhitespace(possibleId.charAt(0))) {
                if (bid == null) continue;
                bid.addMetaInfo(possibleId);
                continue;
            }
            if (bid != null) {
                validLabels.add(bid);
                bid = new BuildID(possibleId);
                continue;
            }
            bid = new BuildID(possibleId);
        }
        if (bid != null) {
            validLabels.add(bid);
        }
        return validLabels;
    }

    private static void clearCachedProperties() {
        versionNumber = null;
        scaProps = null;
    }

    private static void reloadRelativeManagers() {
        RulepackManager.reload();
        ConfigurationManager.reload();
    }

    static {
        CORE_RULES = CommonPropertyKeys.PK_DEFAULT_RULES_DIR.key;
        CUSTOM_RULES = CommonPropertyKeys.PK_CUSTOM_RULES_DIR.key;
        DEFAULT_TYPES = CommonPropertyKeys.PK_DEFAULT_FILE_TYPES.key;
        extensions = null;
        possibleSCAPaths = new ArrayList<File>(6);
        versionPattern = Pattern.compile("(\\d{2}\\.\\d{1,2}(\\.\\d{1,2})?)(\\.\\d{3,5})?$");
    }
}

