/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.configuration.properties;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.rules.RulepackManager;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.FileUtil;
import com.fortify.util.InstallationConfiguration;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FProperties
extends Properties {
    static ILogger logger = MessageManager.getLogger(FProperties.class);
    private String path;
    private int persistanceStrategy = -1;
    private static final int PERSIST_TO_USER = 1;
    private static final int PERSIST_TO_ALLOWED = 2;
    private static final int PERSIST_TO_LOAD = 3;
    private static final int PERSIST_TO_BOTH = 4;
    private static final int NO_PERSIST_STRATEGY = -1;
    private String fullPath;
    private Properties loadedOriginalProps = new Properties();

    private FProperties() {
    }

    private FProperties(Properties defaults) {
        super(defaults);
        this.loadedOriginalProps = new Properties(defaults);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        Object o = super.setProperty(key, value);
        this.propertyChanged();
        return o;
    }

    @Override
    public void putAll(Map t) {
        super.putAll((Map<?, ?>)t);
        this.propertyChanged();
    }

    private void propertyChanged() {
        try {
            switch (this.persistanceStrategy) {
                case 2: {
                    this.saveToAllowed();
                    break;
                }
                case 1: {
                    this.saveToUserStore();
                    break;
                }
                case 3: {
                    this.saveToLoad();
                    break;
                }
                case 4: {
                    this.saveToScaAndTools();
                    break;
                }
            }
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error performing auto-persistance", (Throwable)e);
        }
    }

    private void saveToLoad() throws IOException {
        File loadFile = new File(this.fullPath);
        FileUtil.mkdirs(loadFile.getParentFile());
        loadFile.createNewFile();
        this.storePropsToFile(loadFile, this.combineDefaultAndUserProps());
    }

    public void saveToDefaultStore() throws IOException {
        File defaultProps = this.getDefaultStore();
        if (!defaultProps.exists()) {
            throw new IOException("Properties file does not exist: " + defaultProps.getAbsolutePath());
        }
        Properties defaultsAndUser = this.combineDefaultAndUserProps();
        this.storePropsToFile(defaultProps, defaultsAndUser);
    }

    private void storePropsToFile(File fileToStore, Properties propsToStore) throws IOException {
        for (Map.Entry<Object, Object> prop : propsToStore.entrySet()) {
            String key = (String)prop.getKey();
            String value = (String)prop.getValue();
            if (this.persistanceStrategy == 4) {
                FProperties.writePropertyInFile(fileToStore, key, value);
                continue;
            }
            if (this.loadedOriginalProps.getProperty(key) != null && this.loadedOriginalProps.getProperty(key).equals(value)) continue;
            FProperties.writePropertyInFile(fileToStore, key, value);
            this.loadedOriginalProps.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePropertyInFile(File file, String key, String value) throws IOException {
        value = StringUtil.toJavaAsciiLiteral(value);
        value = value.substring(1, value.length() - 1);
        value = value.replaceAll("\\\\\"", "\"");
        FileInputStream fis = null;
        BufferedReader in = null;
        File outFile = null;
        FileOutputStream fos = null;
        PrintWriter out = null;
        boolean found = false;
        try {
            if (!file.exists()) {
                file.createNewFile();
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Created new file: " + file.getName());
            }
            fis = new FileInputStream(file);
            in = new BufferedReader(new InputStreamReader((InputStream)fis, "8859_1"));
            try {
                outFile = File.createTempFile("fortify-", "-log-tmp.txt");
            }
            catch (IOException e) {
                logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.ERROR, 228, "Unable to create temp file: " + StringUtil.stackTraceToString(e));
            }
            fos = new FileOutputStream(outFile);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "8859_1"));
            String existingLine = in.readLine();
            String replacementLine = key + "=" + value;
            if (existingLine == null) {
                out.println(replacementLine);
                found = true;
            } else {
                do {
                    if (existingLine.trim().startsWith(key + "=")) {
                        found = true;
                        existingLine = replacementLine;
                    }
                    out.println(existingLine);
                } while ((existingLine = in.readLine()) != null);
            }
            if (!found) {
                out.println(key + "=" + value);
            }
            if (out != null) {
                out.flush();
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.flush();
            }
            FileUtil.close(out);
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(out);
        FileUtil.close(in);
        file.delete();
        try {
            FileUtil.copy(outFile, file);
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.ERROR, 228, "Unable to save file: " + file.getAbsolutePath());
        }
    }

    public void saveToUserStore() throws IOException {
        File userProps = this.getUserStore();
        if (!FileUtil.mkdirs(userProps.getParentFile())) {
            throw new IOException("Unable to create path to user properties file" + userProps.getAbsolutePath());
        }
        userProps.createNewFile();
        this.storePropsToFile(userProps, this);
    }

    public void saveToAllowed() throws IOException {
        Properties propsToStore = this.combineDefaultAndUserProps();
        boolean failed = true;
        try {
            File defaultStore = this.getDefaultStore();
            if (FileUtil.mkdirs(defaultStore.getParentFile())) {
                defaultStore.createNewFile();
                this.storePropsToFile(defaultStore, propsToStore);
                failed = false;
            }
        }
        catch (IOException ioe) {
            logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "Storage to core/config disallowed " + this.path, (Throwable)ioe);
        }
        if (failed) {
            File userProps = this.getUserStore();
            if (!FileUtil.mkdirs(userProps.getParentFile())) {
                throw new IOException("Unable to create path to user properties file" + userProps.getAbsolutePath());
            }
            userProps.createNewFile();
            this.storePropsToFile(userProps, propsToStore);
        }
    }

    public void saveToScaAndTools() throws IOException {
        File defaultStore;
        Properties propsToStore = this.combineDefaultAndUserProps();
        File scaStore = this.getSCAStore();
        File storeParent = scaStore.getParentFile();
        if (storeParent != null) {
            try {
                if (FileUtil.mkdirs(storeParent)) {
                    scaStore.createNewFile();
                    this.storePropsToFile(scaStore, propsToStore);
                }
            }
            catch (IOException ioe) {
                logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "Storage to core/config disallowed " + this.path, (Throwable)ioe);
            }
        }
        if ((storeParent = (defaultStore = this.getDefaultStore()).getParentFile()) != null) {
            try {
                if (!scaStore.getAbsolutePath().equals(defaultStore.getAbsolutePath()) && FileUtil.mkdirs(storeParent)) {
                    defaultStore.createNewFile();
                    this.storePropsToFile(defaultStore, propsToStore);
                }
            }
            catch (IOException ioe) {
                logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "Storage to core/config disallowed " + this.path, (Throwable)ioe);
            }
        }
    }

    private File getDefaultStore() {
        return new File(FProperties.getCoreConfig(), this.path);
    }

    private File getUserStore() {
        return new File(InstallationConfiguration.getProductConfigDir(), this.path);
    }

    private File getSCAStore() {
        return new File(FProperties.getCoreConfig(true), this.path);
    }

    private void setPersistanceStrategy(int strategy) {
        this.persistanceStrategy = strategy;
    }

    @Override
    public Set entrySet() {
        return this.combineDefaultAndUserProps().entrySet();
    }

    private Properties combineDefaultAndUserProps() {
        Properties defaultsAndUser = new Properties();
        if (this.defaults != null) {
            defaultsAndUser.putAll((Map<?, ?>)this.defaults);
        }
        for (Object key : this.keySet()) {
            defaultsAndUser.put(key, this.get(key));
        }
        return defaultsAndUser;
    }

    private void setRelativePath(String pathRelativeToCoreConfig) {
        this.path = pathRelativeToCoreConfig;
    }

    private static String getCoreConfig() {
        return FProperties.getCoreConfig(false);
    }

    public static String getCoreConfig(boolean checkSCAFirst) {
        String coreDir;
        if (checkSCAFirst && (coreDir = RulepackManager.getSCAInstallCoreDirectory()) != null) {
            return coreDir + File.separator + "config";
        }
        return SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_CORE) + File.separator + "config";
    }

    public static FProperties getServerProperties(String pathRelativeToCoreConfig) {
        FProperties scaProps = FProperties.loadFortifyProperties(pathRelativeToCoreConfig, true);
        FProperties toolsProps = FProperties.loadFortifyProperties(pathRelativeToCoreConfig, false);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("uploadclient.server");
        keys.add("uploadclient.proxy.server");
        keys.add("uploadclient.proxy.port");
        keys.add("uploadclient.proxy.user");
        keys.add("uploadclient.proxy.pass");
        keys.add("uploadclient.proxy.pass");
        keys.add("install.auto.upgrade");
        keys.add("autoupgrade.server");
        for (String key : keys) {
            String value = toolsProps.getProperty(key);
            if (value != null) {
                scaProps.setProperty(key, value);
                continue;
            }
            scaProps.remove(key);
        }
        scaProps.setPersistanceStrategy(4);
        return scaProps;
    }

    public static FProperties loadAllowedPersistedProps(String pathRelativeToCoreConfig) {
        FProperties ret = FProperties.loadFortifyProperties(pathRelativeToCoreConfig);
        ret.setPersistanceStrategy(2);
        return ret;
    }

    public static FProperties loadUserPersitedProps(String pathRelativeToCoreConfig) {
        FProperties properties = FProperties.loadFortifyProperties(pathRelativeToCoreConfig);
        properties.setPersistanceStrategy(1);
        return properties;
    }

    public static FProperties loadFortifyProperties(String pathRelativeToCoreConfig) {
        return FProperties.loadFortifyProperties(pathRelativeToCoreConfig, false);
    }

    private static FProperties loadFortifyProperties(String pathRelativeToCoreConfig, boolean checkSCAFirst) {
        return FProperties.loadFortifyProperties(pathRelativeToCoreConfig, FProperties.getCoreConfig(checkSCAFirst));
    }

    public static FProperties loadFortifyProperties(String pathRelativeToCoreConfig, String core) {
        Properties defaults = new Properties(System.getProperties());
        try {
            SystemUtil.loadPropertiesFromFile(defaults, new File(core, pathRelativeToCoreConfig), true);
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "Defaults could not be loaded for " + pathRelativeToCoreConfig);
        }
        if (defaults.isEmpty()) {
            defaults = null;
        }
        Properties userSpecific = new Properties();
        try {
            SystemUtil.loadPropertiesFromFile(userSpecific, new File(InstallationConfiguration.getProductConfigDir(), pathRelativeToCoreConfig), true);
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "Properties file does not exist in user directory " + InstallationConfiguration.getProductConfigDir() + File.separator + pathRelativeToCoreConfig);
        }
        if (defaults != null) {
            defaults.putAll((Map<?, ?>)userSpecific);
        } else {
            defaults = userSpecific;
        }
        FProperties ret = new FProperties(defaults);
        ret.setRelativePath(pathRelativeToCoreConfig);
        return ret;
    }

    public boolean getBooleanProperty(String key, String defaultValue) {
        return Boolean.valueOf(this.getProperty(key, defaultValue));
    }

    public static FProperties loadSelfPersistingProperties(String fullPath, Properties defaultProperties) throws IOException {
        Properties existing;
        block4: {
            existing = new Properties();
            try {
                SystemUtil.loadPropertiesFromFile(existing, new File(fullPath), true);
            }
            catch (IOException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error loading properties file " + fullPath + e.getMessage());
                if (defaultProperties != null) break block4;
                throw e;
            }
        }
        if (defaultProperties instanceof FProperties) {
            FProperties defaultFortifyProps = (FProperties)defaultProperties;
            int persistStrategy = defaultFortifyProps.persistanceStrategy;
            defaultFortifyProps.setPersistanceStrategy(-1);
            defaultProperties.putAll((Map<?, ?>)existing);
            defaultFortifyProps.setPersistanceStrategy(persistStrategy);
        } else {
            defaultProperties.putAll((Map<?, ?>)existing);
        }
        FProperties ret = new FProperties(defaultProperties);
        ret.setFullPath(fullPath);
        ret.setPersistanceStrategy(3);
        return ret;
    }

    private void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }
}

