/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.crypto;

import com.fortify.crypto.PasswordBasedCrypto;
import com.fortify.util.Base64;
import com.fortify.util.ConsolePasswordReader;
import com.fortify.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESCrypto {
    private static final String ALGORITHM = "AES";
    private SecretKey secretKey;
    private static final String ENC = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AESCrypto(String keyName, boolean isFile, boolean promptPassword, String passwordPrompt) throws FileNotFoundException, NoSuchAlgorithmException, IOException, PasswordBasedCrypto.EncryptionException {
        String password = null;
        while (true) {
            try {
                if (promptPassword) {
                    ConsolePasswordReader console = new ConsolePasswordReader(passwordPrompt, System.in, System.out);
                    password = console.getPassword();
                    System.out.flush();
                }
                if (isFile) {
                    this.secretKey = AESCrypto.loadSecretKey(keyName, password);
                    return;
                }
                InputStream resource = null;
                try {
                    resource = this.getClass().getClassLoader().getResourceAsStream(keyName);
                    this.secretKey = AESCrypto.loadSecretKey(resource, password);
                    resource.close();
                }
                catch (Throwable throwable) {
                    FileUtil.closeAgain(resource);
                    throw throwable;
                }
                FileUtil.closeAgain(resource);
                return;
            }
            catch (PasswordBasedCrypto.EncryptionException e) {
                System.out.println("Key decryption failed!");
                continue;
            }
            break;
        }
    }

    public AESCrypto(SecretKey secretKey) throws FileNotFoundException, NoSuchAlgorithmException, IOException, PasswordBasedCrypto.EncryptionException {
        this.secretKey = secretKey;
    }

    public String encrypt(String plainText) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, this.secretKey);
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes(ENC));
        return Base64.encode(encryptedBytes);
    }

    public String decrypt(String cipherText) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)this.secretKey, cipher.getParameters());
        byte[] decryptedBytes = cipher.doFinal(Base64.decode(cipherText));
        return new String(decryptedBytes, ENC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey createAndSaveSecretKey(Integer keySize, String filename, String password) throws FileNotFoundException, NoSuchAlgorithmException, IOException, PasswordBasedCrypto.EncryptionException {
        SecretKey secretKey;
        FileOutputStream fos = null;
        try {
            String encodedKeyString;
            fos = new FileOutputStream(filename);
            SecretKey secretKey2 = AESCrypto.createSecretKey(keySize);
            byte[] keyBytes = secretKey2.getEncoded();
            String returnEncodedKeyString = encodedKeyString = Base64.encode(keyBytes);
            if (password != null) {
                PasswordBasedCrypto pbe = new PasswordBasedCrypto(password, PasswordBasedCrypto.DEFAULT_SALT, 15, ENC);
                returnEncodedKeyString = pbe.encrypt(encodedKeyString);
            }
            fos.write(returnEncodedKeyString.getBytes(ENC));
            fos.close();
            secretKey = secretKey2;
        }
        catch (Throwable throwable) {
            FileUtil.closeAgain(fos);
            throw throwable;
        }
        FileUtil.closeAgain(fos);
        return secretKey;
    }

    private static SecretKey createSecretKey(Integer keySize) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(ALGORITHM);
        keyGen.init(keySize);
        SecretKey secretKey = keyGen.generateKey();
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey loadSecretKey(String filename, String password) throws FileNotFoundException, NoSuchAlgorithmException, IOException, PasswordBasedCrypto.EncryptionException {
        SecretKey secretKey;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            SecretKey retval = AESCrypto.loadSecretKey(fis, password);
            fis.close();
            secretKey = retval;
        }
        catch (Throwable throwable) {
            FileUtil.closeAgain(fis);
            throw throwable;
        }
        FileUtil.closeAgain(fis);
        return secretKey;
    }

    public static SecretKey loadSecretKey(InputStream is, String password) throws FileNotFoundException, NoSuchAlgorithmException, IOException, PasswordBasedCrypto.EncryptionException {
        String encodedKeyString;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.copy(is, baos, false);
        baos.close();
        String actualEncodedKeyString = encodedKeyString = new String(baos.toByteArray(), ENC);
        if (password != null) {
            PasswordBasedCrypto pbe = new PasswordBasedCrypto(password, PasswordBasedCrypto.DEFAULT_SALT, 15, ENC);
            actualEncodedKeyString = pbe.decrypt(encodedKeyString);
        }
        byte[] keyBytes = Base64.decode(actualEncodedKeyString);
        return new SecretKeySpec(keyBytes, ALGORITHM);
    }

    public static void main(String[] args) {
        try {
            ConsolePasswordReader console;
            String keyFileName;
            Integer keySize;
            Boolean usePassword;
            String encPassword = null;
            String decPassword = null;
            System.out.println("length: " + args.length);
            if (args.length == 2) {
                usePassword = false;
                keySize = Integer.parseInt(args[0]);
                keyFileName = args[1];
            } else if (args.length == 3) {
                if (!args[0].equals("--password")) {
                    System.out.println("When specifying three arguments, \"--password\" must be first.");
                    AESCrypto.usage();
                    return;
                }
                usePassword = true;
                keySize = Integer.parseInt(args[1]);
                keyFileName = args[2];
            } else {
                AESCrypto.usage();
                return;
            }
            if (keySize != 128 && keySize != 192 && keySize != 256) {
                throw new InvalidKeyException("Invalid key size: " + keySize);
            }
            if (usePassword.booleanValue()) {
                console = new ConsolePasswordReader("Enter password for encryption: ", System.in, System.out);
                encPassword = console.getPassword();
                System.out.flush();
            }
            SecretKey secretKey = AESCrypto.createAndSaveSecretKey(keySize, keyFileName, encPassword);
            System.out.println("Key saved to: " + keyFileName);
            if (usePassword.booleanValue()) {
                console = new ConsolePasswordReader("Enter password for decryption: ", System.in, System.out);
                decPassword = console.getPassword();
                System.out.flush();
            }
            SecretKey secretKeyRecovered = AESCrypto.loadSecretKey(keyFileName, decPassword);
            System.out.println("Key verification: " + (secretKey.equals(secretKeyRecovered) ? "passed" : "failed"));
            String plainText = "~!@#$%^&*()_+`1234567890-=QWERTYUIOP{}|[]\\:\";'<>?,./";
            AESCrypto aes = new AESCrypto(keyFileName, true, usePassword, "Enter password for key: ");
            String cipherText = aes.encrypt(plainText);
            String decryptedText = aes.decrypt(cipherText);
            System.out.println("Encryption verification: " + (plainText.equals(decryptedText) ? "passed" : "failed"));
        }
        catch (NumberFormatException e) {
            System.out.println(" Invalid number: " + args[0] + "\n" + e);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(" No Such Algorithm exists " + e);
        }
        catch (NoSuchPaddingException e) {
            System.out.println(" No Such Padding exists " + e);
        }
        catch (InvalidKeyException e) {
            System.out.println(" Invalid Key " + e);
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            System.out.println(" Bad Padding " + e);
        }
        catch (IllegalBlockSizeException e) {
            System.out.println(" Illegal Block Size " + e);
        }
        catch (InvalidAlgorithmParameterException e) {
            System.out.println(" Invalid Parameter " + e);
        }
        catch (PasswordBasedCrypto.EncryptionException e) {
            System.out.println(" EncryptionException: Error performing password based encryption: " + e);
        }
        catch (IOException e) {
            System.out.println(" IOException " + e);
            return;
        }
    }

    private static void usage() {
        System.out.println("Used to create a new AES symmetric encryption key.");
        System.out.println("Usage: AESCrypto [--password] <128|192|256> <newKeyFile>");
        System.out.println("       Note: Depends on common.jar and common13.jar");
        System.out.println("       Note: To use 192 and 256-bit keys, you must download the Unlimited");
        System.out.println("             Strength Policy jars from Sun and drop them into jre/lib/security");
    }
}

