/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.crypto;

import com.fortify.util.Base64;
import com.fortify.util.ConsolePasswordReader;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PasswordBasedCrypto {
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private static final String ALGORITHM = "PBEWithSHA1AndDESede";
    private String characterEncoding;
    public static final byte[] DEFAULT_SALT = new byte[]{70, 111, 114, 116, 105, 102, 121, 33};
    public static final int DEFAULT_ITERATIONS = 15;

    public PasswordBasedCrypto(String passphrase, byte[] salt, int iterationCount, String characterEncoding) throws EncryptionException {
        assert (passphrase != null);
        assert (passphrase.length() >= 6);
        assert (salt != null);
        assert (salt.length == 8);
        assert (iterationCount > 6 && iterationCount < 20);
        assert (characterEncoding != null);
        this.characterEncoding = characterEncoding;
        try {
            PBEParameterSpec params = new PBEParameterSpec(salt, iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(passphrase.toCharArray());
            SecretKey key = SecretKeyFactory.getInstance(ALGORITHM).generateSecret(keySpec);
            this.encryptCipher = Cipher.getInstance(ALGORITHM);
            this.encryptCipher.init(1, (Key)key, params);
            this.decryptCipher = Cipher.getInstance(ALGORITHM);
            this.decryptCipher.init(2, (Key)key, params);
        }
        catch (Exception e) {
            throw new EncryptionException("Problem constucting " + this.getClass().getName(), e);
        }
    }

    public synchronized String encrypt(String dataString) throws EncryptionException {
        assert (dataString != null);
        try {
            byte[] encryptedDataBytes = this.encryptCipher.doFinal(dataString.getBytes(this.characterEncoding));
            return Base64.encode(encryptedDataBytes);
        }
        catch (Exception e) {
            throw new EncryptionException("Problem encrypting string", e);
        }
    }

    public synchronized String decrypt(String encodedEncryptedDataString) throws EncryptionException {
        assert (encodedEncryptedDataString != null);
        try {
            byte[] encryptedDataBytes = Base64.decode(encodedEncryptedDataString);
            byte[] recoveredDataBytes = this.decryptCipher.doFinal(encryptedDataBytes);
            return new String(recoveredDataBytes, this.characterEncoding);
        }
        catch (Exception e) {
            throw new EncryptionException("Problem decrypting string", e);
        }
    }

    public static void main(String[] args) {
        try {
            ConsolePasswordReader console = new ConsolePasswordReader("Enter password used to test encryption: ", System.in, System.out);
            String password = console.getPassword();
            System.out.flush();
            System.out.println("Password    ....................[" + password + "]");
            PasswordBasedCrypto dataStringEncryptAgent = new PasswordBasedCrypto(password, DEFAULT_SALT, 15, "UTF-8");
            String dataString = args.length == 0 ? "The quick brown fox jumps over the lazy dog." : args[0];
            System.out.println("Data string ....................[" + dataString + "]");
            String encodedEncryptedDataString = dataStringEncryptAgent.encrypt(dataString);
            String recoveredDataString = dataStringEncryptAgent.decrypt(encodedEncryptedDataString);
            System.out.println("Recovered data string ..........[" + recoveredDataString + "]");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static class EncryptionException
    extends Exception {
        private EncryptionException(String text, Exception chain) {
            super(text, chain);
        }
    }
}

