/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteCountingInputStream
extends InputStream {
    private final InputStream is;
    private long counter = 0L;

    public long getBytesRead() {
        return this.counter;
    }

    public ByteCountingInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        int result = this.is.read();
        if (result >= 0) {
            ++this.counter;
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.is.read(b);
        this.counter += (long)result;
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.is.read(b, off, len);
        this.counter += (long)result;
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.is.skip(n);
        this.counter += result;
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.counter = 0L;
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }
}

