/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import com.fortify.util.NumberUtil;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class CheckpointingGZipOutputStream
extends GZIPOutputStream {
    private int uncompressedBytes = 0;
    private final Os os = (Os)this.out;
    private Field syncFlushField;
    private static final byte[] NoBytes = new byte[0];
    private static final byte[] EmptyEndBlock = new byte[]{3, 0};

    private void setSyncFlushTrue() {
        try {
            try {
                this.syncFlushField = DeflaterOutputStream.class.getDeclaredField("syncFlush");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (this.syncFlushField != null) {
                this.syncFlushField.setAccessible(true);
                this.syncFlushField.setBoolean(this, true);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("setSyncFlushTrue failed", ex);
        }
    }

    public CheckpointingGZipOutputStream(FileOutputStream out, int size) throws IOException {
        super((OutputStream)new Os(out), size);
        this.setSyncFlushTrue();
    }

    public CheckpointingGZipOutputStream(FileOutputStream out) throws IOException {
        super(new Os(out));
        this.setSyncFlushTrue();
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        super.write(bytes, off, len);
        this.uncompressedBytes += len;
    }

    public void checkpoint() throws IOException {
        if (this.syncFlushField != null) {
            this.flush();
        } else {
            this.def.setInput(NoBytes, 0, 0);
            this.def.setLevel(0);
            this.deflateall();
            this.def.setLevel(-1);
            this.deflateall();
        }
        byte[] endBlock = null;
        int endBlockBytes = 0;
        if (this.os.hasZSyncFlushTail()) {
            endBlock = EmptyEndBlock;
            endBlockBytes = endBlock.length;
        } else {
            int i;
            byte lastByte = this.os.getLastByte();
            for (i = 0; i < 8 && (lastByte & 1 << 7 - i) == 0; ++i) {
            }
            endBlock = NumberUtil.intToByteArray(3 << 8 - i);
            endBlockBytes = (8 - i + 2 + 8 + 7) / 8;
        }
        this.os.fos.write(endBlock, 0, endBlockBytes);
        this.os.fos.write(NumberUtil.intToByteArray((int)this.crc.getValue()));
        this.os.fos.write(NumberUtil.intToByteArray(this.uncompressedBytes));
        this.os.fos.flush();
        FileChannel channel = this.os.fos.getChannel();
        channel.position(channel.position() - (long)(8 + endBlockBytes));
    }

    private void deflateall() throws IOException {
        int len;
        while ((len = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, len);
        }
    }

    static class Os
    extends FilterOutputStream {
        final FileOutputStream fos;
        final byte[] buf = new byte[4];
        int pos = -1;
        static final byte[] ZSyncFlushTail = new byte[]{0, 0, -1, -1};

        Os(FileOutputStream out) {
            super(out);
            this.fos = out;
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.pos = (this.pos + 1) % this.buf.length;
            this.buf[this.pos] = (byte)b;
        }

        public byte getLastByte() {
            return this.buf[this.pos];
        }

        public boolean hasZSyncFlushTail() {
            boolean zsf = true;
            int p = (this.pos + 1) % this.buf.length;
            for (int i = 0; i < ZSyncFlushTail.length; ++i) {
                if (ZSyncFlushTail[i] != this.buf[p]) {
                    zsf = false;
                    break;
                }
                p = (p + 1) % this.buf.length;
            }
            return zsf;
        }
    }
}

