/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.sun.istack.Nullable;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.util.HashMap;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMParserWithLineNumbers
extends DOMParser {
    static ILogger logger = MessageManager.getLogger(DOMParserWithLineNumbers.class);
    private XMLLocator locator;
    String inputFile = "Reader";
    Reader xmlReader = null;
    private final HashMap<Node, Integer> lineMap;
    private HashMap<Node, Integer> columnMap = null;
    private boolean logParseExceptions = true;

    public DOMParserWithLineNumbers(Reader reader, String filename, HashMap<Node, Integer> lineMap, boolean needNS) {
        this.xmlReader = reader;
        this.inputFile = filename;
        this.lineMap = lineMap;
        this.initialize(needNS);
    }

    public DOMParserWithLineNumbers(String filename, HashMap<Node, Integer> lineMap) {
        this.inputFile = filename;
        this.lineMap = lineMap;
        this.initialize();
    }

    public DOMParserWithLineNumbers(Reader reader, HashMap<Node, Integer> lineMap, HashMap<Node, Integer> columnMap, boolean logParseExceptions) {
        this.xmlReader = reader;
        this.lineMap = lineMap;
        this.columnMap = columnMap;
        this.logParseExceptions = logParseExceptions;
        this.initialize();
    }

    public DOMParserWithLineNumbers(Reader reader, HashMap<Node, Integer> lineMap, HashMap<Node, Integer> columnMap) {
        this(reader, lineMap, columnMap, true);
    }

    private void initialize() {
        this.initialize(false);
    }

    private void initialize(boolean needNs) {
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.setFeature("http://xml.org/sax/features/validation", false);
            this.setFeature("http://xml.org/sax/features/namespaces", needNs);
            this.setProperty("http://apache.org/xml/properties/security-manager", new SecurityManager());
        }
        catch (SAXException e) {
            this.writeParseProblemToLog("Error initializing parsing for {}: {}", this.inputFile, e.getMessage());
        }
        catch (Exception e) {
            throw new FortifyException(new Message(3, 206, this.inputFile), (Throwable)e);
        }
        this.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                byte[] nothing = new byte[]{};
                return new InputSource(new ByteArrayInputStream(nothing));
            }
        });
        this.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) {
                DOMParserWithLineNumbers.this.writeParseProblemToLog("Error while parsing {}{}: {}", new Object[]{DOMParserWithLineNumbers.this.inputFile, DOMParserWithLineNumbers.this.locator == null ? "" : ":" + DOMParserWithLineNumbers.this.locator.getLineNumber(), exception.getMessage()});
            }

            @Override
            public void fatalError(SAXParseException exception) {
                DOMParserWithLineNumbers.this.writeParseProblemToLog("Error while parsing {}{}: {}", new Object[]{DOMParserWithLineNumbers.this.inputFile, DOMParserWithLineNumbers.this.locator == null ? "" : ":" + DOMParserWithLineNumbers.this.locator.getLineNumber(), exception.getMessage()});
            }

            @Override
            public void warning(SAXParseException exception) {
                DOMParserWithLineNumbers.this.writeParseProblemToLog("Warning while parsing {}{}: {}", new Object[]{DOMParserWithLineNumbers.this.inputFile, DOMParserWithLineNumbers.this.locator == null ? "" : ":" + DOMParserWithLineNumbers.this.locator.getLineNumber(), exception.getMessage()});
            }
        });
    }

    private void writeParseProblemToLog(String message, Object ... params) {
        if (this.logParseExceptions) {
            logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.DEV, message, params);
        }
    }

    public void startElement(QName elementQName, XMLAttributes attrList, Augmentations augs) throws XNIException {
        super.startElement(elementQName, attrList, augs);
        this.saveLineNumber(this.currentNode());
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        this.locator = locator;
        this.saveLineNumber(this.currentNode());
    }

    public void comment(XMLString text, Augmentations augs) {
        super.comment(text, augs);
        Node current = this.currentNode();
        if (current == null) {
            return;
        }
        Node justAddedCommentNode = current.getLastChild();
        if (justAddedCommentNode instanceof Comment) {
            this.saveLineNumber(justAddedCommentNode);
        }
    }

    @Nullable
    private Node currentNode() {
        return this.fCurrentNode;
    }

    private void saveLineNumber(@Nullable Node node) {
        if (node == null || this.locator == null) {
            return;
        }
        this.lineMap.put(node, this.locator.getLineNumber());
        if (this.columnMap != null) {
            this.columnMap.put(node, this.locator.getColumnNumber());
        }
    }

    /*
     * Exception decompiling
     */
    public Document getDocument() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

