/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import com.fortify.util.SystemUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileFinder {
    private static Logger l = Logger.getLogger(FileFinder.class.getName());
    private static final Pattern dockerExtension = Pattern.compile("\\*?\\.?(D|d)ockerfile");
    private static char[] regexSpecialChars = new char[]{'.', '^', '$', '+', '!', '(', ')', '[', ']', '{', '}', '|'};

    private FileFinder() {
    }

    public static List<File> find(String fileOrDirectory) throws SecurityException {
        ArrayList<File> files = new ArrayList<File>();
        FileFinder.getFileList(fileOrDirectory, Pattern.compile(".*"), files, new HashSet<String>());
        return files;
    }

    public static List<File> find(String fileOrDirectory, String fileRegex) throws SecurityException {
        ArrayList<File> files = new ArrayList<File>();
        FileFinder.getFileList(fileOrDirectory, Pattern.compile(fileRegex), files, new HashSet<String>());
        return files;
    }

    public static List<File> find(String[] filesOrDirectories) throws SecurityException {
        ArrayList<File> files = new ArrayList<File>();
        Pattern pattern = Pattern.compile(".*");
        for (int i = 0; i < filesOrDirectories.length; ++i) {
            FileFinder.getFileList(filesOrDirectories[i], pattern, files, new HashSet<String>());
        }
        return files;
    }

    public static List<File> find(String[] filesOrDirectories, String fileRegex) throws SecurityException {
        ArrayList<File> files = new ArrayList<File>();
        Pattern pattern = Pattern.compile(fileRegex);
        for (int i = 0; i < filesOrDirectories.length; ++i) {
            FileFinder.getFileList(filesOrDirectories[i], pattern, files, new HashSet<String>());
        }
        return files;
    }

    public static List<File> findDirectory(String dir) {
        return FileFinder.findDirectory(dir, ".*");
    }

    public static List<File> findDirectory(String dir, String dirRegex) {
        File file = new File(dir);
        ArrayList<File> dirs = new ArrayList<File>();
        HashSet<String> dirVisited = new HashSet<String>();
        Pattern pattern = Pattern.compile(dirRegex);
        if (!file.exists()) {
            l.severe(dir + " does not exist.");
            return dirs;
        }
        if (file.isFile()) {
            return dirs;
        }
        FileFinder.findDir(file, pattern, dirs, dirVisited);
        return dirs;
    }

    public static List<String> findDirectoryByPattern(File baseDir, String pathTemplateSuffix) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (!baseDir.exists()) {
            l.info(baseDir.getAbsolutePath() + " does not exist.");
            return dirs;
        }
        if (baseDir.isFile()) {
            return dirs;
        }
        HashSet<String> dirVisited = new HashSet<String>();
        String pathTemplate = FileFinder.getCanonicalPathSafely(baseDir);
        if (!pathTemplate.endsWith(File.separator)) {
            pathTemplate = pathTemplate + File.separator;
        }
        pathTemplate = pathTemplate + pathTemplateSuffix;
        if (File.separator.equals("\\")) {
            pathTemplate = pathTemplate.replace("/", "\\");
        }
        int depth = pathTemplate.endsWith("**") ? 1 : 1000;
        pathTemplate = pathTemplate.replace("**", ".*").replace(".*", "?.*").replace("\\", "\\\\");
        Pattern pattern = Pattern.compile(pathTemplate, SystemUtil.isWindows() ? 2 : 0);
        FileFinder.findDirByPattern(baseDir, pattern, dirs, dirVisited, depth);
        return dirs;
    }

    private static void findDir(File dir, Pattern pattern, List<File> dirList, Set<String> dirVisited) throws SecurityException {
        File[] files;
        try {
            String dirName = dir.getCanonicalPath();
            if (dirVisited.contains(dirName)) {
                return;
            }
            dirVisited.add(dirName);
        }
        catch (Exception dirName) {
            // empty catch block
        }
        if (pattern.matcher(dir.getName()).matches()) {
            dirList.add(dir);
        }
        if ((files = dir.listFiles()) == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            FileFinder.findDir(files[i], pattern, dirList, dirVisited);
        }
    }

    private static void findDirByPattern(File curDir, Pattern pattern, List<String> dirList, Set<String> dirVisited, int depth) {
        try {
            String curDirPath = FileFinder.getCanonicalPathSafely(curDir);
            if (dirVisited.contains(curDirPath)) {
                return;
            }
            dirVisited.add(curDirPath);
            if (pattern.matcher(curDirPath).matches()) {
                dirList.add(FileFinder.normalizePath(curDirPath));
            }
            if (depth > 0) {
                File[] subDirs;
                --depth;
                for (File subDir : subDirs = curDir.listFiles(DirFilter.s_dirFilter)) {
                    FileFinder.findDirByPattern(subDir, pattern, dirList, dirVisited, depth);
                }
            }
        }
        catch (Exception ignore) {
            l.info("findDirByPattern. Exception = " + ignore.getMessage());
        }
    }

    private static void getFileList(String fileOrDirectory, Pattern pattern, List<File> fileList, Set<String> dirList) throws SecurityException {
        File file = new File(fileOrDirectory);
        if (!file.exists()) {
            l.severe(fileOrDirectory + " does not exist.");
            return;
        }
        if (file.isFile()) {
            if (pattern.matcher(file.getName()).matches()) {
                fileList.add(file);
            }
        } else {
            FileFinder.doFind(file, pattern, fileList, dirList);
        }
    }

    private static void doFind(File dir, Pattern pattern, List<File> fileList, Set<String> dirList) throws SecurityException {
        try {
            String dirName = dir.getCanonicalPath();
            if (dirList.contains(dirName)) {
                return;
            }
            dirList.add(dirName);
        }
        catch (Exception dirName) {
            // empty catch block
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                if (!pattern.matcher(files[i].getName()).matches()) continue;
                fileList.add(files[i]);
                continue;
            }
            if (!files[i].isDirectory()) continue;
            FileFinder.doFind(files[i], pattern, fileList, dirList);
        }
    }

    public static Set<File> getFileList(String dirPattern) {
        return FileFinder.getFileList(dirPattern, null);
    }

    public static Set<File> getFileList(String dirPattern, String[] defaultFilter) {
        return FileFinder.getFileList(new File("."), dirPattern, defaultFilter);
    }

    public static Set<File> getFileList(File currentDirectory, String dirPattern, String[] defaultFilter) {
        return FileFinder.getFileList(currentDirectory, dirPattern, defaultFilter, false);
    }

    public static Set<File> getFileList(File currentDirectory, String dirPattern, String[] defaultFilter, boolean ignoreCase) {
        File baseDir;
        dirPattern = dirPattern.replace(File.separatorChar, '/');
        StringBuffer sb = new StringBuffer(dirPattern);
        HashSet<File> retVal = new HashSet<File>();
        if (dirPattern.charAt(0) != '*') {
            File f;
            int star = dirPattern.indexOf(42);
            int sep = star == -1 ? dirPattern.lastIndexOf(47) : dirPattern.substring(0, star).lastIndexOf(47);
            if (sep != -1) {
                String firstDir = dirPattern.substring(0, sep + 1);
                f = new File(firstDir);
                if (!f.isAbsolute()) {
                    f = new File(currentDirectory, firstDir);
                }
            } else {
                f = currentDirectory;
            }
            if (!f.exists()) {
                return retVal;
            }
            sb.delete(0, sep + 1);
            baseDir = f;
        } else {
            baseDir = currentDirectory;
        }
        FileFinder.collectFiles(retVal, baseDir, sb, defaultFilter, new HashSet<String>(), false, ignoreCase);
        return retVal;
    }

    public static String normalizePath(String path) {
        return (path = path.replace('\\', '/')).endsWith("/") ? path : path + "/";
    }

    public static String getCanonicalPathSafely(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            l.severe("Fail to get canonical path for the file \"" + file.getAbsolutePath() + "\"");
            return file.getAbsolutePath();
        }
    }

    private static void collectFiles(Set<File> fileSet, File baseDir, StringBuffer pattern, String[] defaultFilter, Set<String> visitedDirs, boolean recurse, boolean ignoreCase) {
        StringBuffer newPattern;
        String subPattern;
        int separatorIndex;
        String baseDirStr = FileFinder.getCanonicalPathSafely(baseDir);
        if (visitedDirs.contains(baseDirStr) || pattern == null || pattern.length() == 0) {
            return;
        }
        visitedDirs.add(baseDirStr);
        while (pattern.indexOf("**") == 0 && pattern.length() >= 3) {
            if (pattern.charAt(2) != '/') {
                return;
            }
            recurse = true;
            pattern.delete(0, 3);
        }
        if (pattern.length() == 2 && pattern.toString().equals("**")) {
            recurse = true;
            pattern.delete(0, 1);
        }
        if ((separatorIndex = pattern.indexOf("/")) != -1) {
            subPattern = pattern.substring(0, separatorIndex);
            newPattern = new StringBuffer(pattern.substring(separatorIndex + 1));
        } else {
            newPattern = pattern;
            subPattern = pattern.toString();
        }
        int separatorIndexOfNP = newPattern.indexOf("/");
        boolean newPatternEqualsStarStar = newPattern.length() == 2 && newPattern.toString().equals("**");
        String tmpRegex = FileFinder.buildFilenameRegex(subPattern, defaultFilter);
        Pattern p = Pattern.compile(tmpRegex, SystemUtil.isWindows() || ignoreCase ? 2 : 0);
        boolean needFileMatch = (separatorIndex == -1 || separatorIndex != -1 && newPatternEqualsStarStar) && subPattern.length() != 0;
        File[] files = baseDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isHidden()) continue;
            String fileName = file.getName();
            if (p.matcher(fileName).matches()) {
                if (file.isDirectory()) {
                    boolean terminate;
                    boolean bl = terminate = recurse && separatorIndex != -1;
                    if (terminate && separatorIndexOfNP == -1 && !newPatternEqualsStarStar) {
                        FileFinder.collectFiles(fileSet, file, pattern, defaultFilter, new HashSet<String>(), recurse, ignoreCase);
                    }
                    if (!recurse && separatorIndex == -1) continue;
                    FileFinder.collectFiles(fileSet, file, newPattern, defaultFilter, visitedDirs, terminate ? false : recurse, ignoreCase);
                    continue;
                }
                if (!needFileMatch) continue;
                fileSet.add(file);
                continue;
            }
            if (!recurse || !file.isDirectory()) continue;
            FileFinder.collectFiles(fileSet, file, pattern, defaultFilter, visitedDirs, recurse, ignoreCase);
        }
    }

    private static String buildFilenameRegex(String filenamePattern, String[] defaultFilter) {
        StringBuilder tmp = new StringBuilder("(");
        boolean includeExtensionlessDocker = false;
        boolean includeEmpty = false;
        if (dockerExtension.matcher(filenamePattern).matches()) {
            includeExtensionlessDocker = true;
        }
        for (int i = 0; i < filenamePattern.length(); ++i) {
            char c = filenamePattern.charAt(i);
            if (c == '*') {
                tmp.append(".*");
                if (i != filenamePattern.length() - 1 || defaultFilter == null) continue;
                tmp.append("\\.(");
                String prefix = "";
                for (int j = 0; j < defaultFilter.length; ++j) {
                    String ext = defaultFilter[j];
                    if (ext.length() == 0) {
                        includeEmpty = true;
                        continue;
                    }
                    if (dockerExtension.matcher(ext).matches()) {
                        includeExtensionlessDocker = true;
                        continue;
                    }
                    tmp.append(prefix);
                    tmp.append(ext);
                    prefix = "|";
                }
                tmp.append(")");
                continue;
            }
            if (FileFinder.isRegexSpecialChar(c)) {
                tmp.append('\\');
                tmp.append(c);
                continue;
            }
            tmp.append(c);
        }
        if (includeEmpty) {
            tmp.append("|[^.]+");
        }
        tmp.append(")");
        if (includeExtensionlessDocker) {
            tmp.append("|((D|d)ockerfile.*)");
            tmp.append("|(.*\\.(D|d)ockerfile)");
        }
        return tmp.toString();
    }

    private static boolean isRegexSpecialChar(char c) {
        for (char regexChar : regexSpecialChars) {
            if (c != regexChar) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Set<File> s = FileFinder.getFileList(args[0]);
        Iterator<File> iter = s.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    private static class DirFilter
    implements FileFilter {
        public static DirFilter s_dirFilter = new DirFilter();

        private DirFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

