/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import com.fortify.io.FortifyCastorVisitor;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;

public abstract class FortifyCastorBase {
    static ILogger logger = MessageManager.getLogger(FortifyCastorBase.class);

    public void childrenAccept(FortifyCastorVisitor visitor, Object data) {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> rtype;
            Method method = methods[i];
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length > 0 || !method.getName().startsWith("get") || (rtype = method.getReturnType()).isPrimitive()) continue;
            if (Collection.class.isAssignableFrom(rtype)) {
                try {
                    Collection value = (Collection)method.invoke((Object)this, new Object[0]);
                    if (value == null) continue;
                    Iterator vit = value.iterator();
                    while (vit.hasNext()) {
                        try {
                            FortifyCastorBase obj = (FortifyCastorBase)vit.next();
                            visitor.visit(obj, data);
                        }
                        catch (ClassCastException cce) {
                            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception traversing object", (Throwable)cce);
                        }
                    }
                    continue;
                }
                catch (IllegalAccessException iae) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception traversing object", (Throwable)iae);
                    continue;
                }
                catch (InvocationTargetException ite) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception traversing object", (Throwable)ite);
                    continue;
                }
            }
            if (!FortifyCastorBase.class.isAssignableFrom(rtype)) continue;
            try {
                FortifyCastorBase val = (FortifyCastorBase)method.invoke((Object)this, new Object[0]);
                if (val == null) continue;
                visitor.visit(val, data);
                continue;
            }
            catch (IllegalAccessException iae) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception traversing object", (Throwable)iae);
                continue;
            }
            catch (InvocationTargetException ite) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception traversing object", (Throwable)ite);
            }
        }
    }

    public boolean equals(Object obj) {
        return true;
    }
}

