/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;

public class UnicodeReader
extends Reader {
    private final PushbackInputStream in;
    private final String defaultEncoding;
    private String finalEncoding = null;
    private Reader reader = null;

    public UnicodeReader(InputStream in, String defaultEncoding) {
        this.in = new PushbackInputStream(in, 4);
        this.defaultEncoding = defaultEncoding;
    }

    private void setup() throws IOException {
        byte[] bom = new byte[4];
        int read = this.in.read(bom, 0, 4);
        this.finalEncoding = null;
        if (read >= 2) {
            switch (bom[0]) {
                case 0: {
                    if (read != 4 || bom[1] != 0 || bom[2] != -2 || bom[3] != -1) {
                        this.in.unread(bom, 0, read);
                        break;
                    }
                    this.finalEncoding = "UTF-32BE";
                    break;
                }
                case -1: {
                    if (read == 4 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                        this.finalEncoding = "UTF-32LE";
                        break;
                    }
                    if (read >= 2 && bom[1] == -2) {
                        this.finalEncoding = "UTF-16LE";
                        this.in.unread(bom, 2, read - 2);
                        break;
                    }
                    this.in.unread(bom, 0, read);
                    break;
                }
                case -2: {
                    if (read >= 2 && bom[1] == -1) {
                        this.finalEncoding = "UTF-16BE";
                        this.in.unread(bom, 2, read - 2);
                        break;
                    }
                    this.in.unread(bom, 0, read);
                    break;
                }
                case -17: {
                    if (read >= 3 && bom[1] == -69 && bom[2] == -65) {
                        this.finalEncoding = "UTF-8";
                        this.in.unread(bom, 3, read - 3);
                        break;
                    }
                    this.in.unread(bom, 0, read);
                    break;
                }
                default: {
                    this.in.unread(bom, 0, read);
                    break;
                }
            }
        } else if (read > 0) {
            this.in.unread(bom, 0, read);
        }
        if (this.finalEncoding == null) {
            this.finalEncoding = this.defaultEncoding;
        }
        this.reader = this.finalEncoding == null ? new InputStreamReader(this.in) : new InputStreamReader((InputStream)this.in, this.finalEncoding);
    }

    public String getFinalEncoding() {
        return this.finalEncoding;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.in.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.reader == null) {
            this.setup();
        }
        return this.reader.read(cbuf, off, len);
    }
}

