/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import com.fortify.exceptions.FortifyException;
import com.fortify.io.DOMParserWithLineNumbers;
import com.fortify.messaging.Message;
import com.fortify.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlDocument {
    Document document = null;
    File file = null;
    String filePath = null;
    HashMap lineMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument(File file) throws FortifyException {
        this.file = file;
        this.filePath = file.getPath();
        ZipFile zip = null;
        FileInputStream fis1 = null;
        FileInputStream fis2 = null;
        try {
            zip = new ZipFile(file);
            if (zip.size() != 1) {
                fis1 = new FileInputStream(file);
                this.init(new InputSource(fis1));
            }
            this.init(new InputSource(zip.getInputStream(zip.entries().nextElement())));
        }
        catch (IOException e) {
            try {
                try {
                    fis2 = new FileInputStream(file);
                    this.init(new InputSource(fis2));
                }
                catch (FileNotFoundException fnfe) {
                    throw new FortifyException(new Message(3, 101, file.getAbsolutePath()), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(zip);
                FileUtil.close(fis1);
                FileUtil.close(fis2);
                throw throwable;
            }
            FileUtil.close(zip);
            FileUtil.close(fis1);
            FileUtil.close(fis2);
        }
        FileUtil.close(zip);
        FileUtil.close(fis1);
        FileUtil.close(fis2);
    }

    public XmlDocument(InputStream in) throws FortifyException {
        this(in, null);
    }

    public XmlDocument(InputStream in, String filePath) throws FortifyException {
        this.filePath = filePath;
        this.init(new InputSource(in));
    }

    public XmlDocument(Reader reader) throws FortifyException {
        this(reader, null);
    }

    public XmlDocument(Reader reader, String filePath) throws FortifyException {
        this.filePath = filePath;
        this.init(new InputSource(reader));
    }

    private void init(InputSource in) throws FortifyException {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new FortifyException(new Message(3, 206, this.filePath), (Throwable)e);
        }
        docBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                byte[] nothing = new byte[]{};
                return new InputSource(new ByteArrayInputStream(nothing));
            }
        });
        try {
            this.document = docBuilder.parse(in);
        }
        catch (SAXParseException spe) {
            String line = spe.getLineNumber() != -1 ? Integer.toString(spe.getLineNumber()) : "<unknown>";
            throw new FortifyException(new Message(3, 222, this.filePath, line, spe.getLocalizedMessage()), (Throwable)spe);
        }
        catch (Exception e) {
            throw new FortifyException(new Message(3, 206, this.filePath), (Throwable)e);
        }
    }

    public XmlDocument(Reader reader, String filename, boolean keepLineNumbers, boolean needNs) {
        this.lineMap = new HashMap();
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(reader, filename, (HashMap<Node, Integer>)this.lineMap, needNs);
        this.document = parser.getDocument();
    }

    public HashMap getLineMap() {
        return this.lineMap;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getDocumentRoot() {
        if (this.document != null) {
            return this.document.getDocumentElement();
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public static String getFirstValueByTagName(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            Node child = nodes.item(0).getFirstChild();
            return child == null ? null : child.getNodeValue();
        }
        return null;
    }

    public static Element getFirstElementByTagName(Element element, String tagName) {
        NodeList nodes = element.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }
}

