/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io;

import com.fortify.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFileWriter {
    private ZipOutputStream zip;

    public ZipFileWriter(OutputStream out) {
        this(out, "");
    }

    public ZipFileWriter(OutputStream out, String comment) {
        this(out, comment, true);
    }

    public ZipFileWriter(OutputStream out, String comment, boolean compress) {
        this.zip = new ZipOutputStream(out);
        if (!compress) {
            this.zip.setLevel(0);
        }
        this.zip.setComment(comment);
    }

    public void addFile(File file) throws IOException {
        this.addFile(file, file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, String entryName) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.addFile(fis, entryName);
        }
        catch (Throwable throwable) {
            FileUtil.close(fis);
            throw throwable;
        }
        FileUtil.close(fis);
    }

    public void addFile(InputStream is, String entryName) throws IOException {
        int length;
        ZipEntry entry = new ZipEntry(entryName);
        this.zip.putNextEntry(entry);
        byte[] buf = new byte[2048];
        while ((length = is.read(buf)) >= 0) {
            this.zip.write(buf, 0, length);
        }
        this.zip.closeEntry();
        is.close();
    }

    public void addFile(String fileName, byte[] data) throws IOException {
        ZipEntry entry = new ZipEntry(fileName);
        this.zip.putNextEntry(entry);
        this.zip.write(data, 0, data.length);
        this.zip.closeEntry();
    }

    public void write() throws IOException {
        this.zip.flush();
        this.zip.close();
    }
}

