/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.dynamictext;

import com.fortify.io.dynamictext.Paragraph;
import com.fortify.io.dynamictext.Replaceable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.core.util.CycleBreaker;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Content
extends Replaceable
implements Serializable {
    private List<Paragraph> paragraphList = new ArrayList<Paragraph>();

    public void addParagraph(Paragraph vParagraph) throws IndexOutOfBoundsException {
        this.paragraphList.add(vParagraph);
    }

    public void addParagraph(int index, Paragraph vParagraph) throws IndexOutOfBoundsException {
        this.paragraphList.add(index, vParagraph);
    }

    public Enumeration<? extends Paragraph> enumerateParagraph() {
        return Collections.enumeration(this.paragraphList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof Content) {
            Content temp = (Content)obj;
            if (this.paragraphList != null) {
                if (temp.paragraphList == null) {
                    return false;
                }
                if (this.paragraphList != temp.paragraphList) {
                    boolean tmcycle;
                    boolean thcycle = CycleBreaker.startingToCycle(this.paragraphList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle(temp.paragraphList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle(this.paragraphList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle(temp.paragraphList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.paragraphList.equals(temp.paragraphList)) {
                            CycleBreaker.releaseCycleHandle(this.paragraphList);
                            CycleBreaker.releaseCycleHandle(temp.paragraphList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle(this.paragraphList);
                        CycleBreaker.releaseCycleHandle(temp.paragraphList);
                    }
                }
            } else if (temp.paragraphList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Paragraph getParagraph(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.paragraphList.size()) {
            throw new IndexOutOfBoundsException("getParagraph: Index value '" + index + "' not in range [0.." + (this.paragraphList.size() - 1) + "]");
        }
        return this.paragraphList.get(index);
    }

    public Paragraph[] getParagraph() {
        Paragraph[] array = new Paragraph[]{};
        return this.paragraphList.toArray(array);
    }

    public List<Paragraph> getParagraphAsReference() {
        return this.paragraphList;
    }

    public int getParagraphCount() {
        return this.paragraphList.size();
    }

    @Override
    public int hashCode() {
        int resultHc = super.hashCode();
        if (this.paragraphList != null && !CycleBreaker.startingToCycle(this.paragraphList)) {
            resultHc = 37 * resultHc + this.paragraphList.hashCode();
            CycleBreaker.releaseCycleHandle(this.paragraphList);
        }
        return resultHc;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Paragraph> iterateParagraph() {
        return this.paragraphList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllParagraph() {
        this.paragraphList.clear();
    }

    public boolean removeParagraph(Paragraph vParagraph) {
        boolean removed = this.paragraphList.remove(vParagraph);
        return removed;
    }

    public Paragraph removeParagraphAt(int index) {
        Paragraph obj = this.paragraphList.remove(index);
        return obj;
    }

    public void setParagraph(int index, Paragraph vParagraph) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.paragraphList.size()) {
            throw new IndexOutOfBoundsException("setParagraph: Index value '" + index + "' not in range [0.." + (this.paragraphList.size() - 1) + "]");
        }
        this.paragraphList.set(index, vParagraph);
    }

    public void setParagraph(Paragraph[] vParagraphArray) {
        this.paragraphList.clear();
        for (int i = 0; i < vParagraphArray.length; ++i) {
            this.paragraphList.add(vParagraphArray[i]);
        }
    }

    public void setParagraph(List<Paragraph> vParagraphList) {
        this.paragraphList.clear();
        this.paragraphList.addAll(vParagraphList);
    }

    public void setParagraphAsReference(List<Paragraph> paragraphList) {
        this.paragraphList = paragraphList;
    }

    public static Content unmarshalContent(Reader reader) throws MarshalException, ValidationException {
        return (Content)Unmarshaller.unmarshal(Content.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

