/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.fvdl;

import com.fortify.exceptions.FortifyException;
import com.fortify.io.fvdl.AnalysisInfo;
import com.fortify.io.fvdl.Dataflow;
import com.fortify.io.fvdl.DataflowPool;
import com.fortify.io.fvdl.FVDL;
import com.fortify.io.fvdl.InstanceInfo;
import com.fortify.io.fvdl.Node;
import com.fortify.io.fvdl.NodeRef;
import com.fortify.io.fvdl.Path;
import com.fortify.io.fvdl.ReasonChoice;
import com.fortify.io.fvdl.Unified;
import com.fortify.io.fvdl.UnifiedInduction;
import com.fortify.io.fvdl.UnifiedInductionPool;
import com.fortify.io.fvdl.UnifiedInductionRef;
import com.fortify.io.fvdl.UnifiedNode;
import com.fortify.io.fvdl.UnifiedNodePoolType;
import com.fortify.io.fvdl.UnifiedNodeRef;
import com.fortify.io.fvdl.UnifiedPoolNode;
import com.fortify.io.fvdl.UnifiedPrimaryNode;
import com.fortify.io.fvdl.UnifiedReason;
import com.fortify.io.fvdl.UnifiedReasonItem;
import com.fortify.io.fvdl.UnifiedTrace;
import com.fortify.io.fvdl.UnifiedTracePool;
import com.fortify.io.fvdl.UnifiedTracePrimary;
import com.fortify.io.fvdl.UnifiedTracePrimaryEntry;
import com.fortify.io.fvdl.UnifiedTraceRef;
import com.fortify.io.fvdl.Vulnerabilities;
import com.fortify.io.fvdl.Vulnerability;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.util.FileUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;

public class FVDLUtil {
    static ILogger logger = MessageManager.getLogger(FVDLUtil.class);
    private static final XMLContext castorContext = new XMLContext();

    public static Unmarshaller unmarshaller() {
        Unmarshaller result = castorContext.createUnmarshaller();
        result.setClass(FVDL.class);
        result.setWhitespacePreserve(true);
        return result;
    }

    public static Marshaller marshaller() {
        return castorContext.createMarshaller();
    }

    private FVDLUtil() {
    }

    public static InstanceInfo clone(InstanceInfo ii) {
        InstanceInfo newii = new InstanceInfo();
        if (ii != null) {
            newii.setInstanceDescription(ii.getInstanceDescription());
            newii.setInstanceID(ii.getInstanceID());
            newii.setInstanceSeverity(ii.getInstanceSeverity());
        } else {
            newii.setInstanceDescription("");
        }
        return newii;
    }

    public static FVDL unmarshal(String infile) throws MarshalException, ValidationException {
        Reader reader = null;
        try {
            reader = FVDLUtil.getFVDLReader(infile);
            FVDL fVDL = (FVDL)FVDLUtil.unmarshaller().unmarshal(reader);
            return fVDL;
        }
        finally {
            FileUtil.close(reader);
        }
    }

    public static FVDL unmarshal(InputStream is) throws IOException, MarshalException, ValidationException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        return (FVDL)FVDLUtil.unmarshaller().unmarshal((Reader)reader);
    }

    public static Reader getFVDLReader(String zipFile) {
        Reader is;
        try {
            ZipFile zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> it = zip.entries();
            ZipEntry elt = null;
            boolean found = false;
            while (it.hasMoreElements()) {
                elt = it.nextElement();
                if (elt.getName().indexOf(".fvdl") == -1) continue;
                found = true;
                break;
            }
            if (!found) {
                elt = zip.entries().nextElement();
            }
            is = new InputStreamReader(zip.getInputStream(elt), "UTF-8");
        }
        catch (Exception e) {
            try {
                is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(zipFile), "UTF-8"));
            }
            catch (IOException fnne) {
                throw new FortifyException(new Message(4, fnne.getLocalizedMessage()));
            }
        }
        return is;
    }

    public static void expandDataflowNodeRefs(FVDL fvdl) {
        Vulnerabilities vv = fvdl.getVulnerabilities();
        HashMap<Long, Node> nodeMap = new HashMap<Long, Node>();
        DataflowPool p = fvdl.getDataflowPool();
        if (p != null) {
            for (Node n : p.getNodeAsReference()) {
                nodeMap.put(new Long(n.getId()), n);
                n.setId(0L);
            }
        }
        for (Node n : nodeMap.values()) {
            for (NodeRef nr : new ArrayList<NodeRef>(n.getNodeRefAsReference())) {
                Node real = (Node)nodeMap.get(new Long(nr.getId()));
                n.addNode(real);
                n.removeNodeRef(nr);
            }
        }
        for (Vulnerability v : vv.getVulnerabilityAsReference()) {
            AnalysisInfo ai = v.getAnalysisInfo();
            Dataflow df = ai.getDataflow();
            if (df == null) continue;
            for (Path path : df.getPathAsReference()) {
                for (NodeRef nr : new ArrayList<NodeRef>(path.getNodeRefAsReference())) {
                    path.addNode((Node)nodeMap.get(new Long(nr.getId())));
                    path.removeNodeRef(nr);
                }
            }
        }
    }

    public static void expandUnifiedNodeRefs(FVDL fvdl) {
        HashMap<Integer, UnifiedPrimaryNode> traces = new HashMap<Integer, UnifiedPrimaryNode>();
        UnifiedNodePoolType nodePool = fvdl.getUnifiedNodePool();
        if (nodePool != null) {
            for (UnifiedPoolNode node : nodePool.getUnifiedPoolNodeAsReference()) {
                UnifiedPrimaryNode pnode = new UnifiedPrimaryNode();
                pnode.setAction(node.getAction());
                if (node.hasDetailsOnly()) {
                    pnode.setDetailsOnly(node.getDetailsOnly());
                }
                pnode.setLabel(node.getLabel());
                pnode.setSecondaryLocation(node.getSecondaryLocation());
                pnode.setSourceLocation(node.getSourceLocation());
                pnode.setUnifiedKnowledge(node.getUnifiedKnowledge());
                pnode.setUnifiedReason(node.getUnifiedReason());
                traces.put(new Integer(node.getId()), pnode);
            }
        }
        for (UnifiedPrimaryNode pnode : traces.values()) {
            UnifiedReason r = pnode.getUnifiedReason();
            if (r == null) continue;
            for (int i = 0; i < r.getUnifiedReasonItem().length; ++i) {
                UnifiedInductionRef uir;
                UnifiedReasonItem item = r.getUnifiedReasonItem()[i];
                ReasonChoice rc = item.getReasonChoice();
                UnifiedTrace t = rc.getTrace();
                if (t != null) {
                    FVDLUtil.inlineUnifiedNodeRefs(t, traces);
                }
                if ((uir = rc.getInductionRef()) == null) continue;
                uir.setId(0);
            }
        }
        Vulnerabilities vulns = fvdl.getVulnerabilities();
        for (Vulnerability vuln : vulns.getVulnerabilityAsReference()) {
            Unified u = vuln.getAnalysisInfo().getUnified();
            if (u == null) continue;
            for (UnifiedTrace t : u.getTraceAsReference()) {
                FVDLUtil.inlineUnifiedNodeRefs(t, traces);
            }
        }
    }

    private static void inlineUnifiedNodeRefs(UnifiedTrace t, Map traces) {
        UnifiedTracePrimary utp = t.getUnifiedTracePrimary();
        for (UnifiedTracePrimaryEntry e : utp.getUnifiedTracePrimaryEntryAsReference()) {
            if (e.getNodeRef() == null) continue;
            UnifiedNodeRef ref = e.getNodeRef();
            UnifiedPrimaryNode node = (UnifiedPrimaryNode)traces.get(new Integer(ref.getId()));
            e.setNodeRef(null);
            e.setUnifiedPrimaryNode(node);
        }
    }

    public static void expandUnifiedTraceRefs(FVDL fvdl) {
        HashMap<Integer, UnifiedTrace> traces = new HashMap<Integer, UnifiedTrace>();
        UnifiedTracePool tracePool = fvdl.getUnifiedTracePool();
        if (tracePool != null) {
            for (UnifiedTrace trace : tracePool.getTraceAsReference()) {
                traces.put(new Integer(trace.getId()), trace);
                trace.setId(0);
            }
        }
        Iterator<UnifiedTrace> it = traces.values().iterator();
        while (it.hasNext()) {
            FVDLUtil.inlineUnifiedTraceRefs(traces, it.next());
        }
        UnifiedNodePoolType unp = fvdl.getUnifiedNodePool();
        if (unp != null) {
            for (UnifiedNode unifiedNode : unp.getUnifiedPoolNodeAsReference()) {
                FVDLUtil.inlineUnifiedTraceRefs(traces, unifiedNode);
            }
        }
        Vulnerabilities vulns = fvdl.getVulnerabilities();
        for (Vulnerability vuln : vulns.getVulnerabilityAsReference()) {
            Unified ut = vuln.getAnalysisInfo().getUnified();
            if (ut == null) continue;
            Iterator<UnifiedTrace> ti = ut.getTraceAsReference().iterator();
            while (ti.hasNext()) {
                FVDLUtil.inlineUnifiedTraceRefs(traces, ti.next());
            }
        }
    }

    private static void inlineUnifiedTraceRefs(Map traces, UnifiedTrace trace) {
        List<UnifiedTracePrimaryEntry> nodes = trace.getUnifiedTracePrimary().getUnifiedTracePrimaryEntryAsReference();
        for (UnifiedTracePrimaryEntry e : nodes) {
            UnifiedPrimaryNode node = e.getUnifiedPrimaryNode();
            if (node == null) continue;
            FVDLUtil.inlineUnifiedTraceRefs(traces, node);
        }
    }

    private static void inlineUnifiedTraceRefs(Map traces, UnifiedNode node) {
        UnifiedReason reason = node.getUnifiedReason();
        if (reason != null) {
            for (int i = 0; i < reason.getUnifiedReasonItem().length; ++i) {
                UnifiedReasonItem item = reason.getUnifiedReasonItem()[i];
                ReasonChoice choice = item.getReasonChoice();
                if (choice.getTraceRef() != null) {
                    UnifiedTraceRef traceref = choice.getTraceRef();
                    UnifiedTrace repl = (UnifiedTrace)traces.get(new Integer(traceref.getId()));
                    choice.setTraceRef(null);
                    choice.setTrace(repl);
                }
                if (choice.getInductionRef() == null) continue;
                choice.getInductionRef().setId(0);
            }
        }
    }

    public static void expandUnifiedInductionNodeRefs(FVDL fvdl) {
        UnifiedInductionPool pool = fvdl.getUnifiedInductionPool();
        if (pool == null) {
            return;
        }
        for (UnifiedInduction ui : pool.getInductionAsReference()) {
            ui.setId(0);
            UnifiedTraceRef utr = ui.getTraceRef();
            if (utr == null) continue;
            utr.setId(0);
        }
    }

    static {
        castorContext.setProperty("org.exolab.castor.xml.serializer.factory", (Object)"org.exolab.castor.xml.XercesXMLSerializerFactory");
        castorContext.setProperty("org.exolab.castor.xml.lenient.sequence.order", true);
        castorContext.setProperty("org.exolab.castor.regexp", (Object)"org.exolab.castor.util.JakartaOroEvaluator");
        castorContext.setProperty("org.exolab.castor.indent", true);
        try {
            castorContext.addPackage("com.fortify.io.fvdl");
        }
        catch (ResolverException e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception initializing castor context", (Throwable)e);
        }
    }
}

