/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.fvdl;

import com.fortify.io.fvdl.DataflowNode;
import com.fortify.io.fvdl.NodeRef;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.core.util.CycleBreaker;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Node
extends DataflowNode
implements Serializable {
    private long id;
    private boolean _hasid;
    private List<Node> nodeList = new ArrayList<Node>();
    private List<NodeRef> nodeRefList = new ArrayList<NodeRef>();

    public void addNode(Node vNode) throws IndexOutOfBoundsException {
        this.nodeList.add(vNode);
    }

    public void addNode(int index, Node vNode) throws IndexOutOfBoundsException {
        this.nodeList.add(index, vNode);
    }

    public void addNodeRef(NodeRef vNodeRef) throws IndexOutOfBoundsException {
        this.nodeRefList.add(vNodeRef);
    }

    public void addNodeRef(int index, NodeRef vNodeRef) throws IndexOutOfBoundsException {
        this.nodeRefList.add(index, vNodeRef);
    }

    public void deleteId() {
        this._hasid = false;
    }

    public Enumeration<? extends Node> enumerateNode() {
        return Collections.enumeration(this.nodeList);
    }

    public Enumeration<? extends NodeRef> enumerateNodeRef() {
        return Collections.enumeration(this.nodeRefList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof Node) {
            boolean tmcycle;
            boolean thcycle;
            Node temp = (Node)obj;
            if (this.id != temp.id) {
                return false;
            }
            if (this._hasid != temp._hasid) {
                return false;
            }
            if (this.nodeList != null) {
                if (temp.nodeList == null) {
                    return false;
                }
                if (this.nodeList != temp.nodeList) {
                    thcycle = CycleBreaker.startingToCycle(this.nodeList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle(temp.nodeList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle(this.nodeList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle(temp.nodeList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.nodeList.equals(temp.nodeList)) {
                            CycleBreaker.releaseCycleHandle(this.nodeList);
                            CycleBreaker.releaseCycleHandle(temp.nodeList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle(this.nodeList);
                        CycleBreaker.releaseCycleHandle(temp.nodeList);
                    }
                }
            } else if (temp.nodeList != null) {
                return false;
            }
            if (this.nodeRefList != null) {
                if (temp.nodeRefList == null) {
                    return false;
                }
                if (this.nodeRefList != temp.nodeRefList) {
                    thcycle = CycleBreaker.startingToCycle(this.nodeRefList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle(temp.nodeRefList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle(this.nodeRefList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle(temp.nodeRefList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.nodeRefList.equals(temp.nodeRefList)) {
                            CycleBreaker.releaseCycleHandle(this.nodeRefList);
                            CycleBreaker.releaseCycleHandle(temp.nodeRefList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle(this.nodeRefList);
                        CycleBreaker.releaseCycleHandle(temp.nodeRefList);
                    }
                }
            } else if (temp.nodeRefList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public Node getNode(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.nodeList.size()) {
            throw new IndexOutOfBoundsException("getNode: Index value '" + index + "' not in range [0.." + (this.nodeList.size() - 1) + "]");
        }
        return this.nodeList.get(index);
    }

    public Node[] getNode() {
        Node[] array = new Node[]{};
        return this.nodeList.toArray(array);
    }

    public List<Node> getNodeAsReference() {
        return this.nodeList;
    }

    public int getNodeCount() {
        return this.nodeList.size();
    }

    public NodeRef getNodeRef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.nodeRefList.size()) {
            throw new IndexOutOfBoundsException("getNodeRef: Index value '" + index + "' not in range [0.." + (this.nodeRefList.size() - 1) + "]");
        }
        return this.nodeRefList.get(index);
    }

    public NodeRef[] getNodeRef() {
        NodeRef[] array = new NodeRef[]{};
        return this.nodeRefList.toArray(array);
    }

    public List<NodeRef> getNodeRefAsReference() {
        return this.nodeRefList;
    }

    public int getNodeRefCount() {
        return this.nodeRefList.size();
    }

    public boolean hasId() {
        return this._hasid;
    }

    @Override
    public int hashCode() {
        int resultHc = super.hashCode();
        resultHc = 37 * resultHc + (int)(this.id ^ this.id >>> 32);
        resultHc = 37 * resultHc + (this._hasid ? 0 : 1);
        if (this.nodeList != null && !CycleBreaker.startingToCycle(this.nodeList)) {
            resultHc = 37 * resultHc + this.nodeList.hashCode();
            CycleBreaker.releaseCycleHandle(this.nodeList);
        }
        if (this.nodeRefList != null && !CycleBreaker.startingToCycle(this.nodeRefList)) {
            resultHc = 37 * resultHc + this.nodeRefList.hashCode();
            CycleBreaker.releaseCycleHandle(this.nodeRefList);
        }
        return resultHc;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Node> iterateNode() {
        return this.nodeList.iterator();
    }

    public Iterator<? extends NodeRef> iterateNodeRef() {
        return this.nodeRefList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllNode() {
        this.nodeList.clear();
    }

    public void removeAllNodeRef() {
        this.nodeRefList.clear();
    }

    public boolean removeNode(Node vNode) {
        boolean removed = this.nodeList.remove(vNode);
        return removed;
    }

    public Node removeNodeAt(int index) {
        Node obj = this.nodeList.remove(index);
        return obj;
    }

    public boolean removeNodeRef(NodeRef vNodeRef) {
        boolean removed = this.nodeRefList.remove(vNodeRef);
        return removed;
    }

    public NodeRef removeNodeRefAt(int index) {
        NodeRef obj = this.nodeRefList.remove(index);
        return obj;
    }

    public void setId(long id) {
        this.id = id;
        this._hasid = true;
    }

    public void setNode(int index, Node vNode) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.nodeList.size()) {
            throw new IndexOutOfBoundsException("setNode: Index value '" + index + "' not in range [0.." + (this.nodeList.size() - 1) + "]");
        }
        this.nodeList.set(index, vNode);
    }

    public void setNode(Node[] vNodeArray) {
        this.nodeList.clear();
        for (int i = 0; i < vNodeArray.length; ++i) {
            this.nodeList.add(vNodeArray[i]);
        }
    }

    public void setNode(List<Node> vNodeList) {
        this.nodeList.clear();
        this.nodeList.addAll(vNodeList);
    }

    public void setNodeAsReference(List<Node> nodeList) {
        this.nodeList = nodeList;
    }

    public void setNodeRef(int index, NodeRef vNodeRef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.nodeRefList.size()) {
            throw new IndexOutOfBoundsException("setNodeRef: Index value '" + index + "' not in range [0.." + (this.nodeRefList.size() - 1) + "]");
        }
        this.nodeRefList.set(index, vNodeRef);
    }

    public void setNodeRef(NodeRef[] vNodeRefArray) {
        this.nodeRefList.clear();
        for (int i = 0; i < vNodeRefArray.length; ++i) {
            this.nodeRefList.add(vNodeRefArray[i]);
        }
    }

    public void setNodeRef(List<NodeRef> vNodeRefList) {
        this.nodeRefList.clear();
        this.nodeRefList.addAll(vNodeRefList);
    }

    public void setNodeRefAsReference(List<NodeRef> nodeRefList) {
        this.nodeRefList = nodeRefList;
    }

    public static Node unmarshalNode(Reader reader) throws MarshalException, ValidationException {
        return (Node)Unmarshaller.unmarshal(Node.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

