/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.fvdl;

import com.fortify.io.FortifyCastorBase;
import com.fortify.io.fvdl.UnifiedInduction;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.core.util.CycleBreaker;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class UnifiedInductionPool
extends FortifyCastorBase
implements Serializable {
    private List<UnifiedInduction> inductionList = new ArrayList<UnifiedInduction>();

    public void addInduction(UnifiedInduction vInduction) throws IndexOutOfBoundsException {
        this.inductionList.add(vInduction);
    }

    public void addInduction(int index, UnifiedInduction vInduction) throws IndexOutOfBoundsException {
        this.inductionList.add(index, vInduction);
    }

    public Enumeration<? extends UnifiedInduction> enumerateInduction() {
        return Collections.enumeration(this.inductionList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof UnifiedInductionPool) {
            UnifiedInductionPool temp = (UnifiedInductionPool)obj;
            if (this.inductionList != null) {
                if (temp.inductionList == null) {
                    return false;
                }
                if (this.inductionList != temp.inductionList) {
                    boolean tmcycle;
                    boolean thcycle = CycleBreaker.startingToCycle(this.inductionList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle(temp.inductionList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle(this.inductionList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle(temp.inductionList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.inductionList.equals(temp.inductionList)) {
                            CycleBreaker.releaseCycleHandle(this.inductionList);
                            CycleBreaker.releaseCycleHandle(temp.inductionList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle(this.inductionList);
                        CycleBreaker.releaseCycleHandle(temp.inductionList);
                    }
                }
            } else if (temp.inductionList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public UnifiedInduction getInduction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.inductionList.size()) {
            throw new IndexOutOfBoundsException("getInduction: Index value '" + index + "' not in range [0.." + (this.inductionList.size() - 1) + "]");
        }
        return this.inductionList.get(index);
    }

    public UnifiedInduction[] getInduction() {
        UnifiedInduction[] array = new UnifiedInduction[]{};
        return this.inductionList.toArray(array);
    }

    public List<UnifiedInduction> getInductionAsReference() {
        return this.inductionList;
    }

    public int getInductionCount() {
        return this.inductionList.size();
    }

    public int hashCode() {
        int resultHc = super.hashCode();
        if (this.inductionList != null && !CycleBreaker.startingToCycle(this.inductionList)) {
            resultHc = 37 * resultHc + this.inductionList.hashCode();
            CycleBreaker.releaseCycleHandle(this.inductionList);
        }
        return resultHc;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends UnifiedInduction> iterateInduction() {
        return this.inductionList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllInduction() {
        this.inductionList.clear();
    }

    public boolean removeInduction(UnifiedInduction vInduction) {
        boolean removed = this.inductionList.remove(vInduction);
        return removed;
    }

    public UnifiedInduction removeInductionAt(int index) {
        UnifiedInduction obj = this.inductionList.remove(index);
        return obj;
    }

    public void setInduction(int index, UnifiedInduction vInduction) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.inductionList.size()) {
            throw new IndexOutOfBoundsException("setInduction: Index value '" + index + "' not in range [0.." + (this.inductionList.size() - 1) + "]");
        }
        this.inductionList.set(index, vInduction);
    }

    public void setInduction(UnifiedInduction[] vInductionArray) {
        this.inductionList.clear();
        for (int i = 0; i < vInductionArray.length; ++i) {
            this.inductionList.add(vInductionArray[i]);
        }
    }

    public void setInduction(List<UnifiedInduction> vInductionList) {
        this.inductionList.clear();
        this.inductionList.addAll(vInductionList);
    }

    public void setInductionAsReference(List<UnifiedInduction> inductionList) {
        this.inductionList = inductionList;
    }

    public static UnifiedInductionPool unmarshalUnifiedInductionPool(Reader reader) throws MarshalException, ValidationException {
        return (UnifiedInductionPool)Unmarshaller.unmarshal(UnifiedInductionPool.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

