/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.fvdl;

import com.fortify.io.FortifyCastorBase;
import com.fortify.io.fvdl.UnifiedTrace;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.core.util.CycleBreaker;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class UnifiedTracePool
extends FortifyCastorBase
implements Serializable {
    private List<UnifiedTrace> traceList = new ArrayList<UnifiedTrace>();

    public void addTrace(UnifiedTrace vTrace) throws IndexOutOfBoundsException {
        this.traceList.add(vTrace);
    }

    public void addTrace(int index, UnifiedTrace vTrace) throws IndexOutOfBoundsException {
        this.traceList.add(index, vTrace);
    }

    public Enumeration<? extends UnifiedTrace> enumerateTrace() {
        return Collections.enumeration(this.traceList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof UnifiedTracePool) {
            UnifiedTracePool temp = (UnifiedTracePool)obj;
            if (this.traceList != null) {
                if (temp.traceList == null) {
                    return false;
                }
                if (this.traceList != temp.traceList) {
                    boolean tmcycle;
                    boolean thcycle = CycleBreaker.startingToCycle(this.traceList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle(temp.traceList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle(this.traceList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle(temp.traceList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.traceList.equals(temp.traceList)) {
                            CycleBreaker.releaseCycleHandle(this.traceList);
                            CycleBreaker.releaseCycleHandle(temp.traceList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle(this.traceList);
                        CycleBreaker.releaseCycleHandle(temp.traceList);
                    }
                }
            } else if (temp.traceList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public UnifiedTrace getTrace(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.traceList.size()) {
            throw new IndexOutOfBoundsException("getTrace: Index value '" + index + "' not in range [0.." + (this.traceList.size() - 1) + "]");
        }
        return this.traceList.get(index);
    }

    public UnifiedTrace[] getTrace() {
        UnifiedTrace[] array = new UnifiedTrace[]{};
        return this.traceList.toArray(array);
    }

    public List<UnifiedTrace> getTraceAsReference() {
        return this.traceList;
    }

    public int getTraceCount() {
        return this.traceList.size();
    }

    public int hashCode() {
        int resultHc = super.hashCode();
        if (this.traceList != null && !CycleBreaker.startingToCycle(this.traceList)) {
            resultHc = 37 * resultHc + this.traceList.hashCode();
            CycleBreaker.releaseCycleHandle(this.traceList);
        }
        return resultHc;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends UnifiedTrace> iterateTrace() {
        return this.traceList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllTrace() {
        this.traceList.clear();
    }

    public boolean removeTrace(UnifiedTrace vTrace) {
        boolean removed = this.traceList.remove(vTrace);
        return removed;
    }

    public UnifiedTrace removeTraceAt(int index) {
        UnifiedTrace obj = this.traceList.remove(index);
        return obj;
    }

    public void setTrace(int index, UnifiedTrace vTrace) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.traceList.size()) {
            throw new IndexOutOfBoundsException("setTrace: Index value '" + index + "' not in range [0.." + (this.traceList.size() - 1) + "]");
        }
        this.traceList.set(index, vTrace);
    }

    public void setTrace(UnifiedTrace[] vTraceArray) {
        this.traceList.clear();
        for (int i = 0; i < vTraceArray.length; ++i) {
            this.traceList.add(vTraceArray[i]);
        }
    }

    public void setTrace(List<UnifiedTrace> vTraceList) {
        this.traceList.clear();
        this.traceList.addAll(vTraceList);
    }

    public void setTraceAsReference(List<UnifiedTrace> traceList) {
        this.traceList = traceList;
    }

    public static UnifiedTracePool unmarshalUnifiedTracePool(Reader reader) throws MarshalException, ValidationException {
        return (UnifiedTracePool)Unmarshaller.unmarshal(UnifiedTracePool.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

