/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.fvdl.types;

import java.util.HashMap;
import java.util.Map;

public enum EventType {
    SOURCE("Source"),
    SINK("Sink"),
    TRACE("Trace"),
    VALIDATION("Validation");

    private final String value;
    private static final Map<String, EventType> enumConstants;

    private EventType(String value) {
        this.value = value;
    }

    public static EventType fromValue(String value) {
        EventType c = enumConstants.get(value);
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException(value);
    }

    public void setValue(String value) {
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    static {
        enumConstants = new HashMap<String, EventType>();
        for (EventType c : EventType.values()) {
            enumConstants.put(c.value, c);
        }
    }
}

