/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.rule;

import com.fortify.io.rule.VulnRule;
import com.fortify.io.rule.types.LanguageSpecifier;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.core.util.CycleBreaker;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class StructuralRule
extends VulnRule
implements Serializable {
    private LanguageSpecifier language;
    private List<String> predicateList = new ArrayList<String>();

    public void addPredicate(String vPredicate) throws IndexOutOfBoundsException {
        this.predicateList.add(vPredicate);
    }

    public void addPredicate(int index, String vPredicate) throws IndexOutOfBoundsException {
        this.predicateList.add(index, vPredicate);
    }

    public Enumeration<? extends String> enumeratePredicate() {
        return Collections.enumeration(this.predicateList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof StructuralRule) {
            boolean tmcycle;
            boolean thcycle;
            StructuralRule temp = (StructuralRule)obj;
            if (this.language != null) {
                if (temp.language == null) {
                    return false;
                }
                if (this.language != temp.language) {
                    thcycle = CycleBreaker.startingToCycle((Object)((Object)this.language));
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle((Object)((Object)temp.language)))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle((Object)((Object)this.language));
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle((Object)((Object)temp.language));
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.language.equals((Object)temp.language)) {
                            CycleBreaker.releaseCycleHandle((Object)((Object)this.language));
                            CycleBreaker.releaseCycleHandle((Object)((Object)temp.language));
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle((Object)((Object)this.language));
                        CycleBreaker.releaseCycleHandle((Object)((Object)temp.language));
                    }
                }
            } else if (temp.language != null) {
                return false;
            }
            if (this.predicateList != null) {
                if (temp.predicateList == null) {
                    return false;
                }
                if (this.predicateList != temp.predicateList) {
                    thcycle = CycleBreaker.startingToCycle(this.predicateList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle(temp.predicateList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle(this.predicateList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle(temp.predicateList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.predicateList.equals(temp.predicateList)) {
                            CycleBreaker.releaseCycleHandle(this.predicateList);
                            CycleBreaker.releaseCycleHandle(temp.predicateList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle(this.predicateList);
                        CycleBreaker.releaseCycleHandle(temp.predicateList);
                    }
                }
            } else if (temp.predicateList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public LanguageSpecifier getLanguage() {
        return this.language;
    }

    public String getPredicate(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.predicateList.size()) {
            throw new IndexOutOfBoundsException("getPredicate: Index value '" + index + "' not in range [0.." + (this.predicateList.size() - 1) + "]");
        }
        return this.predicateList.get(index);
    }

    public String[] getPredicate() {
        String[] array = new String[]{};
        return this.predicateList.toArray(array);
    }

    public List<String> getPredicateAsReference() {
        return this.predicateList;
    }

    public int getPredicateCount() {
        return this.predicateList.size();
    }

    @Override
    public int hashCode() {
        int resultHc = super.hashCode();
        if (this.language != null && !CycleBreaker.startingToCycle((Object)((Object)this.language))) {
            resultHc = 37 * resultHc + this.language.hashCode();
            CycleBreaker.releaseCycleHandle((Object)((Object)this.language));
        }
        if (this.predicateList != null && !CycleBreaker.startingToCycle(this.predicateList)) {
            resultHc = 37 * resultHc + this.predicateList.hashCode();
            CycleBreaker.releaseCycleHandle(this.predicateList);
        }
        return resultHc;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends String> iteratePredicate() {
        return this.predicateList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPredicate() {
        this.predicateList.clear();
    }

    public boolean removePredicate(String vPredicate) {
        boolean removed = this.predicateList.remove(vPredicate);
        return removed;
    }

    public String removePredicateAt(int index) {
        String obj = this.predicateList.remove(index);
        return obj;
    }

    public void setLanguage(LanguageSpecifier language) {
        this.language = language;
    }

    public void setPredicate(int index, String vPredicate) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.predicateList.size()) {
            throw new IndexOutOfBoundsException("setPredicate: Index value '" + index + "' not in range [0.." + (this.predicateList.size() - 1) + "]");
        }
        this.predicateList.set(index, vPredicate);
    }

    public void setPredicate(String[] vPredicateArray) {
        this.predicateList.clear();
        for (int i = 0; i < vPredicateArray.length; ++i) {
            this.predicateList.add(vPredicateArray[i]);
        }
    }

    public void setPredicate(List<String> vPredicateList) {
        this.predicateList.clear();
        this.predicateList.addAll(vPredicateList);
    }

    public void setPredicateAsReference(List<String> predicateList) {
        this.predicateList = predicateList;
    }

    public static StructuralRule unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (StructuralRule)Unmarshaller.unmarshal(StructuralRule.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

