/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.rule.types;

import java.util.HashMap;
import java.util.Map;

public enum ModifierType {
    PUBLIC("public"),
    PRIVATE("private"),
    PROTECTED("protected"),
    STATIC("static"),
    SUSPEND("suspend"),
    FINAL("final"),
    NATIVE("native"),
    WEBSERVICE("webservice");

    private final String value;
    private static final Map<String, ModifierType> enumConstants;

    private ModifierType(String value) {
        this.value = value;
    }

    public static ModifierType fromValue(String value) {
        ModifierType c = enumConstants.get(value);
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException(value);
    }

    public void setValue(String value) {
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    static {
        enumConstants = new HashMap<String, ModifierType>();
        for (ModifierType c : ModifierType.values()) {
            enumConstants.put(c.value, c);
        }
    }
}

