/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.io.sidl;

import com.fortify.io.FortifyCastorBase;
import com.fortify.io.sidl.Issue;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.core.util.CycleBreaker;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Issues
extends FortifyCastorBase
implements Serializable {
    private List<Issue> issueList = new ArrayList<Issue>();

    public void addIssue(Issue vIssue) throws IndexOutOfBoundsException {
        this.issueList.add(vIssue);
    }

    public void addIssue(int index, Issue vIssue) throws IndexOutOfBoundsException {
        this.issueList.add(index, vIssue);
    }

    public Enumeration<? extends Issue> enumerateIssue() {
        return Collections.enumeration(this.issueList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof Issues) {
            Issues temp = (Issues)obj;
            if (this.issueList != null) {
                if (temp.issueList == null) {
                    return false;
                }
                if (this.issueList != temp.issueList) {
                    boolean tmcycle;
                    boolean thcycle = CycleBreaker.startingToCycle(this.issueList);
                    if (thcycle != (tmcycle = CycleBreaker.startingToCycle(temp.issueList))) {
                        if (!thcycle) {
                            CycleBreaker.releaseCycleHandle(this.issueList);
                        }
                        if (!tmcycle) {
                            CycleBreaker.releaseCycleHandle(temp.issueList);
                        }
                        return false;
                    }
                    if (!thcycle) {
                        if (!this.issueList.equals(temp.issueList)) {
                            CycleBreaker.releaseCycleHandle(this.issueList);
                            CycleBreaker.releaseCycleHandle(temp.issueList);
                            return false;
                        }
                        CycleBreaker.releaseCycleHandle(this.issueList);
                        CycleBreaker.releaseCycleHandle(temp.issueList);
                    }
                }
            } else if (temp.issueList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Issue getIssue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.issueList.size()) {
            throw new IndexOutOfBoundsException("getIssue: Index value '" + index + "' not in range [0.." + (this.issueList.size() - 1) + "]");
        }
        return this.issueList.get(index);
    }

    public Issue[] getIssue() {
        Issue[] array = new Issue[]{};
        return this.issueList.toArray(array);
    }

    public List<Issue> getIssueAsReference() {
        return this.issueList;
    }

    public int getIssueCount() {
        return this.issueList.size();
    }

    public int hashCode() {
        int resultHc = super.hashCode();
        if (this.issueList != null && !CycleBreaker.startingToCycle(this.issueList)) {
            resultHc = 37 * resultHc + this.issueList.hashCode();
            CycleBreaker.releaseCycleHandle(this.issueList);
        }
        return resultHc;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Issue> iterateIssue() {
        return this.issueList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIssue() {
        this.issueList.clear();
    }

    public boolean removeIssue(Issue vIssue) {
        boolean removed = this.issueList.remove(vIssue);
        return removed;
    }

    public Issue removeIssueAt(int index) {
        Issue obj = this.issueList.remove(index);
        return obj;
    }

    public void setIssue(int index, Issue vIssue) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.issueList.size()) {
            throw new IndexOutOfBoundsException("setIssue: Index value '" + index + "' not in range [0.." + (this.issueList.size() - 1) + "]");
        }
        this.issueList.set(index, vIssue);
    }

    public void setIssue(Issue[] vIssueArray) {
        this.issueList.clear();
        for (int i = 0; i < vIssueArray.length; ++i) {
            this.issueList.add(vIssueArray[i]);
        }
    }

    public void setIssue(List<Issue> vIssueList) {
        this.issueList.clear();
        this.issueList.addAll(vIssueList);
    }

    public void setIssueAsReference(List<Issue> issueList) {
        this.issueList = issueList;
    }

    public static Issues unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Issues)Unmarshaller.unmarshal(Issues.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

