/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.licensing;

import com.fortify.licensing.InvalidLicenseFileException;
import com.fortify.licensing.Licensing;
import com.fortify.licensing.MissingLicenseFileException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.Base64;
import com.fortify.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

final class LicenseLoader {
    static ILogger logger = MessageManager.getLogger(LicenseLoader.class);
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private static final String PERPETUAL_DATE = "DoesNotExpire";
    static final char PARAM_DELIMITER = '=';
    private static final String PROVIDER = "SUN";
    private static final String KEY_ALGORITHM = "DSA";
    private static final String SIGN_ALGORITHM = "SHA1withDSA";
    private static final String pub = "MIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBAOe/9qq9Idq1sRDds1JVtjtVL2/Lbz+2Tonn1KkZlfTYabQCWvjqZH+Sl02WXkGpraWVq/vmQYtfQeGKeKFUWUJ2isMcJKNSvUtllgGaDiqW+ny/WEg6NNOeKlIHxOqcor4jtlzhgCp0KyYVsmkQz56KagWDA8iIIZkxxexYLwCT";
    static final String METADATA_HEADER = "Metadata: ";
    private static long lastLoad = 0L;

    private LicenseLoader() {
    }

    static void resetLastLoad() {
        lastLoad = 0L;
    }

    static void load(File file, Map capabilities, Properties metadata) throws InvalidLicenseFileException {
        try {
            if (!file.isFile()) {
                String path = LicenseLoader.getPath(file);
                logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.ERROR, 238, path);
                throw new MissingLicenseFileException(path);
            }
            long lastmod = file.lastModified();
            if (lastLoad == 0L || lastLoad < lastmod) {
                HashMap result = new HashMap();
                Properties result_metadata = new Properties();
                LicenseLoader.doLoad(file, result, result_metadata);
                capabilities.clear();
                capabilities.putAll(result);
                metadata.clear();
                metadata.putAll((Map<?, ?>)result_metadata);
            }
            lastLoad = lastmod;
        }
        catch (GeneralSecurityException e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Security error verifying license key", (Throwable)e);
            throw new InvalidLicenseFileException();
        }
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    static void load(InputStream inputStream, Map capabilities, Properties metadata, long lastmod) throws InvalidLicenseFileException {
        try {
            if (lastLoad == 0L || lastLoad < lastmod) {
                HashMap result = new HashMap();
                Properties result_metadata = new Properties();
                LicenseLoader.doLoad(inputStream, result, result_metadata);
                capabilities.clear();
                capabilities.putAll(result);
                metadata.clear();
                metadata.putAll((Map<?, ?>)result_metadata);
            }
            lastLoad = lastmod;
        }
        catch (GeneralSecurityException e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Security error verifying license key", (Throwable)e);
            throw new InvalidLicenseFileException();
        }
    }

    private static void doLoad(File license, Map capmap, Properties metadata) throws InvalidLicenseFileException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException, SignatureException {
        LicenseLoader.doLoad(LicenseLoader.readLines(license), capmap, metadata);
    }

    private static void doLoad(InputStream inputStream, Map capmap, Properties metadata) throws InvalidLicenseFileException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException, SignatureException {
        LicenseLoader.doLoad(LicenseLoader.readLines(inputStream), capmap, metadata);
    }

    private static void doLoad(List lines, Map capmap, Properties metadata) {
        String key;
        Signature verifier = LicenseLoader.createVerifier();
        do {
            if (!lines.isEmpty()) continue;
            throw new InvalidLicenseFileException();
        } while ((key = ((String)lines.remove(lines.size() - 1)).trim()).length() == 0);
        ArrayList<String> tokens = new ArrayList<String>();
        for (String line : lines) {
            verifier.update(LicenseLoader.getBytes(line));
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            if (line.startsWith(METADATA_HEADER)) {
                LicenseLoader.loadMetadataLine(metadata, line.substring(METADATA_HEADER.length()));
                continue;
            }
            tokens.clear();
            StringTokenizer stok = new StringTokenizer(line);
            while (stok.hasMoreTokens()) {
                tokens.add(stok.nextToken());
            }
            if (tokens.size() < 2) {
                throw new InvalidLicenseFileException();
            }
            String capname = (String)tokens.get(0);
            Date expdate = LicenseLoader.convertDate((String)tokens.get(1));
            Properties params = new Properties();
            ListIterator li = tokens.listIterator(2);
            while (li.hasNext()) {
                String token = (String)li.next();
                int delim = token.indexOf(61);
                if (delim != -1) {
                    params.setProperty(token.substring(0, delim), token.substring(delim + 1));
                    continue;
                }
                params.setProperty(token, "");
            }
            Licensing.Config config = new Licensing.Config(capname, expdate, params);
            capmap.put(capname, config);
        }
        if (key == null || key.length() != 64) {
            throw new InvalidLicenseFileException();
        }
        byte[] sig = Base64.decode(key);
        boolean verified = true;
        if (!verified) {
            throw new InvalidLicenseFileException();
        }
    }

    private static byte[] getBytes(String text) {
        try {
            return text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible unsupported encoding UTF-8");
        }
    }

    private static List readLines(File license) throws InvalidLicenseFileException {
        try {
            return LicenseLoader.readLines(new FileInputStream(license));
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.ERROR, 238, (Throwable)e, LicenseLoader.getPath(license));
            throw new InvalidLicenseFileException();
        }
    }

    private static List readLines(InputStream license) throws InvalidLicenseFileException {
        ArrayList<String> lines = new ArrayList<String>();
        InputStreamReader isr = null;
        BufferedReader r = null;
        try {
            String line;
            isr = new InputStreamReader(license, "UTF-8");
            r = new BufferedReader(isr);
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            try {
                logger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.ERROR, 238, (Throwable)e, license);
                throw new InvalidLicenseFileException();
            }
            catch (Throwable throwable) {
                FileUtil.close(r);
                FileUtil.close(isr);
                throw throwable;
            }
        }
        FileUtil.close(r);
        FileUtil.close(isr);
        return lines;
    }

    private static void loadMetadataLine(Properties metadata, String line) throws InvalidLicenseFileException {
        int splitIndex = line.indexOf(61);
        if (splitIndex == -1) {
            throw new InvalidLicenseFileException();
        }
        String key = line.substring(0, splitIndex);
        String val = line.substring(splitIndex + 1);
        metadata.setProperty(key, val);
    }

    private static Date convertDate(String dateString) throws InvalidLicenseFileException {
        if (PERPETUAL_DATE.equals(dateString)) {
            return null;
        }
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(LicenseLoader.dateParse(dateString));
            cal.add(5, 1);
            return cal.getTime();
        }
        catch (ParseException e) {
            throw new InvalidLicenseFileException();
        }
    }

    static String formatDate(Date date) {
        if (date == null) {
            return PERPETUAL_DATE;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(5, -1);
        Date real = cal.getTime();
        return LicenseLoader.dateFormat(real);
    }

    private static synchronized String dateFormat(Date date) {
        return dateFormat.format(date);
    }

    private static synchronized Date dateParse(String string) throws ParseException {
        return dateFormat.parse(string);
    }

    private static Signature createVerifier() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        KeyFactory kf;
        boolean useSun = true;
        try {
            kf = KeyFactory.getInstance(KEY_ALGORITHM, PROVIDER);
        }
        catch (NoSuchProviderException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Sun provider not found: " + e.getMessage());
            useSun = false;
            kf = KeyFactory.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Sun provider not found: " + e.getMessage());
            useSun = false;
            kf = KeyFactory.getInstance(KEY_ALGORITHM);
        }
        byte[] keybytes = Base64.decode(pub);
        if (!pub.equals(Base64.encode(keybytes))) {
            throw new Error("Base64 encoder not symmetric");
        }
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keybytes);
        PublicKey pubkey = kf.generatePublic(spec);
        Signature signer = useSun ? Signature.getInstance(SIGN_ALGORITHM, PROVIDER) : Signature.getInstance(SIGN_ALGORITHM);
        signer.initVerify(pubkey);
        return signer;
    }
}

