/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.licensing;

import com.fortify.licensing.Capability;
import com.fortify.licensing.InvalidLicenseFileException;
import com.fortify.licensing.LicenseExpiredException;
import com.fortify.licensing.LicenseLoader;
import com.fortify.licensing.MissingLicenseFileException;
import com.fortify.licensing.UnlicensedCapabilityException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.FileUtil;
import com.fortify.util.SystemUtil;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Licensing {
    static ILogger logger = MessageManager.getLogger(Licensing.class);
    public static final String DEFAULT_LICENSE_FILE = "fortify.license";
    private static Map capabilities = new HashMap();
    private static Properties metadata = new Properties();
    private static File licenseFile;
    private static LicenseFileInfo licenseFileInfo;

    private Licensing() {
    }

    public static void requireCapability(Capability capability) throws LicenseExpiredException, UnlicensedCapabilityException, InvalidLicenseFileException, MissingLicenseFileException {
        Licensing.getCapabilityConfig(capability);
    }

    public static boolean hasNoRestrictionCapability(Capability capability) {
        try {
            Licensing.loadLicensing();
            Config config = (Config)capabilities.get(capability.getKey());
            return config == null;
        }
        catch (InvalidLicenseFileException invalidLicenseFileException) {
            return false;
        }
    }

    public static Set getLicensedCapabilities() throws InvalidLicenseFileException {
        Licensing.loadLicensing();
        return new HashSet(capabilities.keySet());
    }

    public static Config[] getAllCapabilities() throws InvalidLicenseFileException, MissingLicenseFileException {
        Licensing.loadLicensing();
        int i = 0;
        Config[] result = new Config[capabilities.size()];
        Iterator it = capabilities.values().iterator();
        while (it.hasNext()) {
            result[i++] = (Config)it.next();
        }
        return result;
    }

    public static Metadata[] getMetadata() throws InvalidLicenseFileException, MissingLicenseFileException {
        Licensing.loadLicensing();
        int i = 0;
        Metadata[] result = new Metadata[metadata.size()];
        Enumeration<?> names = metadata.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String val = metadata.getProperty(key);
            result[i++] = new Metadata(key, val);
        }
        return result;
    }

    public static Config getCapabilityConfig(Capability capability) throws LicenseExpiredException, UnlicensedCapabilityException, InvalidLicenseFileException, MissingLicenseFileException {
        Licensing.loadLicensing();
        Config config = (Config)capabilities.get(capability.getKey());
        if (config == null) {
            throw new UnlicensedCapabilityException(capability);
        }
        if (config.expirationDate != null && config.expirationDate.before(new Date())) {
            throw new LicenseExpiredException(capability, config.expirationDate);
        }
        config.parameterize(capability.getTypes());
        return config;
    }

    public static boolean isValidLicenseFile(File file) {
        try {
            LicenseLoader.load(file, new HashMap(), new Properties());
            return true;
        }
        catch (InvalidLicenseFileException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadLicensing() throws InvalidLicenseFileException {
        File lf = Licensing.getLicenseFile();
        if (lf.getPath().toLowerCase().endsWith(".jar") || lf.getPath().toLowerCase().endsWith(".zip")) {
            ZipFile zf = null;
            try {
                zf = new ZipFile(lf);
                ZipEntry entry = zf.getEntry(DEFAULT_LICENSE_FILE);
                if (entry != null) {
                    LicenseLoader.load(zf.getInputStream(entry), capabilities, metadata, entry.getTime());
                    licenseFileInfo = new LicenseFileInfo(lf.getAbsolutePath(), entry.getName(), entry.getTime());
                    return;
                }
            }
            catch (Exception e) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "failed to extract license from " + lf.getPath());
            }
            finally {
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        LicenseLoader.load(lf, capabilities, metadata);
        licenseFileInfo = new LicenseFileInfo(lf.getAbsolutePath(), lf.getName(), lf.lastModified());
    }

    public static LicenseFileInfo getLicenseFileInfo() {
        if (licenseFileInfo == null) {
            try {
                Licensing.loadLicensing();
            }
            catch (InvalidLicenseFileException invalidLicenseFileException) {
                // empty catch block
            }
        }
        return licenseFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getLicenseFileBytes() {
        File lf = Licensing.getLicenseFile();
        if (lf.getPath().toLowerCase().endsWith(".jar") || lf.getPath().toLowerCase().endsWith(".zip")) {
            ZipFile zf = null;
            try {
                zf = new ZipFile(lf);
                ZipEntry entry = zf.getEntry(DEFAULT_LICENSE_FILE);
                if (entry != null) {
                    byte[] byArray = FileUtil.loadFileAsBytes(zf.getInputStream(entry));
                    return byArray;
                }
            }
            catch (Exception e) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "failed to get license bytes from " + lf.getPath());
            }
            finally {
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            return FileUtil.loadFileAsBytes(lf);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setLicenseFile(File f) {
        if (licenseFile != null && !licenseFile.equals(f)) {
            licenseFileInfo = null;
            capabilities.clear();
            metadata.clear();
            LicenseLoader.resetLastLoad();
        }
        licenseFile = f;
    }

    public static File getLicenseFile() {
        if (licenseFile == null) {
            String defaultLicenseFile = Licensing.getDefaultLicenseFile();
            String filename = SystemUtil.getProperty(CommonPropertyKeys.PK_LICENSE_FILE);
            if (filename == null) {
                filename = defaultLicenseFile;
            }
            licenseFile = new File(filename);
        }
        return licenseFile;
    }

    private static String getDefaultLicenseFile() {
        String installDir = SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_INST_ROOT);
        if (installDir == null) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, CommonPropertyKeys.PK_FORTIFY_INST_ROOT.key + " not set, license loading may be incorrect");
            String core = SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_CORE);
            installDir = core != null ? core + File.separator + ".." : System.getProperty("user.dir");
        }
        return installDir + File.separator + DEFAULT_LICENSE_FILE;
    }

    public static Set get360LicensedCapabilities(File file) throws InvalidLicenseFileException {
        HashMap capabilities = new HashMap();
        Properties metadata = new Properties();
        LicenseLoader.load(file, capabilities, metadata);
        return new HashSet(capabilities.keySet());
    }

    public static final class LicenseFileInfo {
        private String path;
        private String name;
        private long lastModified;

        public LicenseFileInfo(String path, String name, long lastModified) {
            this.path = path;
            this.name = name;
            this.lastModified = lastModified;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public long lastModified() {
            return this.lastModified;
        }
    }

    public static final class Metadata {
        private final String key;
        private final String value;

        public Metadata(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Metadata: " + this.key + '=' + this.value;
        }
    }

    public static final class Config {
        private final String capabilityName;
        private final Date expirationDate;
        private final Properties rawParameters;
        private Map parameters;

        protected Config(String capabilityName, Date expirationDate, Properties parameters) {
            this.capabilityName = capabilityName;
            this.expirationDate = expirationDate;
            this.rawParameters = parameters;
        }

        public String getCapabilityName() {
            return this.capabilityName;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public Properties getRawParameters() {
            return this.rawParameters;
        }

        public Map getParameters() {
            return this.parameters != null ? this.parameters : this.rawParameters;
        }

        void parameterize(Map types) throws InvalidLicenseFileException {
            if (types == null) {
                this.parameters = new HashMap<Object, Object>(this.rawParameters);
            } else {
                HashMap<String, Object> newParams = new HashMap<String, Object>();
                for (Map.Entry entry : types.entrySet()) {
                    String key = (String)entry.getKey();
                    Integer type = (Integer)entry.getValue();
                    String value = this.rawParameters.getProperty(key);
                    newParams.put(key, Config.convert(value, type));
                }
                this.parameters = newParams;
            }
        }

        private static Object convert(String value, Integer type) throws InvalidLicenseFileException {
            if (type == null) {
                return value;
            }
            switch (type) {
                case 1: {
                    return value;
                }
                case 2: {
                    try {
                        return Long.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidLicenseFileException();
                    }
                }
                case 3: {
                    return null;
                }
            }
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Unknown license parameter type " + type);
            return value;
        }

        public String getExpirationString() {
            return LicenseLoader.formatDate(this.expirationDate);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.capabilityName);
            sb.append(" ").append(this.getExpirationString());
            Enumeration<?> e = this.rawParameters.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = this.rawParameters.getProperty(key);
                sb.append(" ").append(key).append('=').append(value);
            }
            return sb.toString();
        }
    }
}

