/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging;

import org.apache.logging.log4j.Level;

public class LoggerConfig {
    public static final String STDERR_PREFIX_MDC_NAME = "prefix";
    public static final String STDERR_FILTER_MDC_NAME = "stderr";
    public static final String STDOUT_FILTER_MDC_NAME = "stdout";
    public static final String DEV_MARKER_NAME = "DEV";
    public static final String USER_MARKER_NAME = "USER";
    public static final String CONSOLE_MARKER_NAME = "CONSOLE";
    public final String defaultLoggerName;
    public Level level;
    public final String filename;
    public final boolean installLoggingPrintStreams;
    public final boolean appendLogFile;

    public LoggerConfig(String defaultLoggerName, Level level, String filename, boolean appendLogFile, boolean installLoggingPrintStreams) {
        this.defaultLoggerName = defaultLoggerName;
        this.level = level;
        this.filename = filename.replace("%20", " ");
        this.appendLogFile = appendLogFile;
        this.installLoggingPrintStreams = installLoggingPrintStreams;
    }

    public String toLogString() {
        try {
            String lineSeparator = System.getProperty("line.separator");
            String prefix = "   ";
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append("level:").append(this.level).append(lineSeparator).append(prefix).append("filename:").append(this.filename).append(lineSeparator).append(prefix).append("appendLogFile:").append(this.appendLogFile).append(lineSeparator).append(prefix).append("installLoggingPrintStreams:").append(this.installLoggingPrintStreams).append(lineSeparator);
            return sb.toString();
        }
        catch (Throwable t) {
            return "";
        }
    }
}

