/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging;

import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.util.HashMap;
import org.apache.logging.log4j.Level;

public class LoggerStats {
    private final HashMap<String, Stats> loggerCounts = new HashMap();
    private final Stats allLoggerStats = new Stats(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCounts(Level level, ILoggerMin logger) {
        this.allLoggerStats.incrementCount(level);
        String loggerName = logger.getName();
        HashMap<String, Stats> hashMap = this.loggerCounts;
        synchronized (hashMap) {
            Stats ls = this.loggerCounts.get(loggerName);
            if (null == ls) {
                ls = new Stats(loggerName);
                this.loggerCounts.put(loggerName, ls);
            }
            ls.incrementCount(level);
        }
    }

    public void logStatistics(ILoggerMin logger) {
        if (logger == null) {
            logger = MessageManager.getLogger(LoggerStats.class);
        }
        StringBuilder sb = new StringBuilder();
        this.allLoggerStats.toLogString(sb);
        for (Stats ls : this.loggerCounts.values()) {
            ls.toLogString(sb);
        }
        logger.log(Level.INFO, ILoggerMin.Marker.DEV, sb.toString());
    }

    class LevelCount {
        Level level;
        int count;

        LevelCount(Level level) {
            this.level = level;
        }

        StringBuilder toLogString(StringBuilder sb) {
            if (null == sb) {
                sb = new StringBuilder();
            }
            sb.append("   level:").append(this.level.toString()).append(" count:").append(this.count);
            return sb;
        }
    }

    class Stats {
        String loggerName;
        int count;
        final HashMap<Level, LevelCount> levelCounts;

        Stats(String loggerName) {
            this.loggerName = loggerName;
            this.levelCounts = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementCount(Level level) {
            HashMap<Level, LevelCount> hashMap = this.levelCounts;
            synchronized (hashMap) {
                LevelCount lc = this.levelCounts.get(level);
                if (null == lc) {
                    lc = new LevelCount(level);
                    this.levelCounts.put(lc.level, lc);
                }
                ++lc.count;
                ++this.count;
            }
        }

        StringBuilder toLogString(StringBuilder sb) {
            String lineSeparator = System.getProperty("line.separator");
            if (null == sb) {
                sb = new StringBuilder();
            }
            sb.append("logger:").append(this.loggerName).append("  count:").append(this.count).append(lineSeparator);
            for (LevelCount lc : this.levelCounts.values()) {
                lc.toLogString(sb).append(lineSeparator);
            }
            return sb;
        }
    }
}

