/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging;

import com.fortify.exceptions.ShutdownError;
import com.fortify.logging.ILoggerMin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;

public class LoggingPrintStream
extends PrintStream {
    private final PipedInputStream in = new PipedInputStream();
    private final ILoggerMin log;
    private final Level logLevel;
    private final Marker logMarker;
    private final String prefix;
    private final Thread monitor;

    public LoggingPrintStream(ILoggerMin log, Level logLevel, Marker logMarker, String prefix) throws IOException {
        super(new PipedOutputStream());
        ((PipedOutputStream)this.out).connect(this.in);
        this.log = log;
        this.logLevel = logLevel;
        this.logMarker = logMarker;
        this.prefix = prefix;
        this.monitor = new Thread((Runnable)new StreamMonitor(), "Stream Monitor " + prefix);
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    public void cleanup(long millis) {
        if (this.monitor.isAlive()) {
            try {
                this.monitor.join(millis);
            }
            catch (InterruptedException ie) {
                throw new ShutdownError(ie);
            }
        }
    }

    private class StreamMonitor
    implements Runnable {
        private StreamMonitor() {
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(LoggingPrintStream.this.in));
            while (true) {
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LoggingPrintStream.this.log.log(LoggingPrintStream.this.logLevel, LoggingPrintStream.this.logMarker, LoggingPrintStream.this.prefix + line);
                    }
                }
                catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    if ("Write end dead".equals(msg) || "Pipe broken".equals(msg)) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            throw new ShutdownError(e);
                        }
                        continue;
                    }
                    LoggingPrintStream.this.log.log(Level.WARN, ILoggerMin.Marker.DEV, "Exception while monitoring stream", (Throwable)ioe);
                }
                break;
            }
        }
    }
}

