/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2;

import com.fortify.logging.log4j2.Utils;
import java.util.ArrayList;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.StringBuilders;

@Plugin(name="CallerLayoutConverter", category="Converter")
@ConverterKeys(value={"caller"})
public class CallerLayoutConverter
extends LogEventPatternConverter {
    private String[] options;

    public static CallerLayoutConverter newInstance(String[] options) {
        return new CallerLayoutConverter(options);
    }

    private CallerLayoutConverter(String[] options) {
        super("Caller", "caller");
        this.options = options;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        ArrayList<StackTraceElement> trace = Utils.getStackTrace(1);
        if (trace.size() == 0) {
            return;
        }
        StringBuilders.appendValue((StringBuilder)toAppendTo, (Object)trace.get(0).toString());
    }
}

