/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import org.apache.logging.log4j.Level;

public class LevelAdjuster {
    private static ILogger logger = MessageManager.getLogger(LevelAdjuster.class);
    private final HashMap<Integer, MsgIdEntry> _entries = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level adjust(int msgId, Level currentLevel) {
        if (msgId == -1) {
            return currentLevel;
        }
        HashMap<Integer, MsgIdEntry> hashMap = this._entries;
        synchronized (hashMap) {
            MsgIdEntry me = this._entries.get(msgId);
            if (null == me) {
                return currentLevel;
            }
            return me.level;
        }
    }

    public int load(File file) {
        int rval = 0;
        file = file.getAbsoluteFile();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode actualObj = mapper.readTree(file);
            for (JsonNode node : actualObj) {
                try {
                    int id = node.path("id").asInt();
                    String levelString = node.path("level").asText();
                    Level level = Level.valueOf((String)levelString);
                    this.addLevelAdustment(id, level);
                }
                catch (Exception e) {
                    logger.log(Level.ERROR, ILoggerMin.Marker.DEV, String.format("swallowing exception processing element: '%s'", node.asText()), (Throwable)e);
                }
                ++rval;
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.INFO, ILoggerMin.Marker.DEV, String.format("message level adjustment file not found: %s", file.getAbsolutePath()));
        }
        catch (Exception e) {
            logger.log(Level.WARN, ILoggerMin.Marker.DEV, String.format("swallowing exception loading message level adjustment file:%s", file.getAbsolutePath()));
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLevelAdustment(int msgId, Level level) {
        HashMap<Integer, MsgIdEntry> hashMap = this._entries;
        synchronized (hashMap) {
            MsgIdEntry me = new MsgIdEntry(msgId, level);
            this._entries.put(msgId, me);
        }
    }

    class MsgIdEntry {
        final int msgId;
        final Level level;

        MsgIdEntry(int msgId, Level level) {
            this.msgId = msgId;
            this.level = level;
        }
    }
}

