/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILoggerMin;
import com.fortify.logging.log4j2.LoggerFactory;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageReceiver;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public class LogReceiver
implements MessageReceiver {
    @Override
    public void receive(Message m) {
        this.log(m);
    }

    @Override
    public void receive(FortifyException exception) {
        this.log(exception.getFortifyMessage());
    }

    @Override
    public void receive(Message message, Throwable cause) {
        message.setThrowable(cause);
        this.log(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Message message) {
        ILoggerMin logger;
        Level level = message.getLogLevel();
        String loggerName = message.loggerName;
        if (null == loggerName || loggerName.length() == 0) {
            loggerName = LoggerFactory.defaultLoggerFactory.getLoggerConfig().defaultLoggerName;
        }
        if (!(logger = LoggerFactory.defaultLoggerFactory.getLoggerInternal(loggerName)).isEnabled(level)) {
            return;
        }
        try (CloseableThreadContext.Instance ctc1 = CloseableThreadContext.put((String)"msgId", (String)Integer.toString(message.getErrorCode())).put("severity", Message.getSeverityString(message.getSeverity()));){
            if (message.hasErrorCode()) {
                logger.log(level, message.getMarker(), message.getLocalizedMessage(), message.getThrowable());
            } else if (message.getThrowable() != null) {
                if (message.getSupplier() != null) {
                    logger.log(level, message.getMarker(), message.getSupplier(), message.getThrowable());
                } else {
                    logger.log(level, message.getMarker(), message.getLocalizedMessage(), message.getThrowable());
                }
            } else if (message.getSupplier() != null) {
                logger.log(level, message.getMarker(), message.getSupplier());
            } else if (message.getSuppliers() != null) {
                logger.log(level, message.getMarker(), message.getLocalizedMessage(), message.getSuppliers());
            } else if (message.getParameters() != null) {
                logger.log(level, message.getMarker(), message.getLocalizedMessage(), message.getParameters());
            } else {
                logger.log(level, message.getMarker(), message.getLocalizedMessage());
            }
        }
    }
}

