/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2;

import com.fortify.logging.ILoggerFactory;
import com.fortify.logging.ILoggerMin;
import com.fortify.logging.LoggerConfig;
import com.fortify.logging.LoggerStats;
import com.fortify.logging.LoggingPrintStream;
import com.fortify.logging.log4j2.LoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.FileUtil;
import com.fortify.util.Pair;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class LoggerFactory
implements ILoggerFactory {
    public static ILoggerFactory defaultLoggerFactory = new LoggerFactory();
    private static final String logFilePathProp = "com.fortify.sca.LogFilePath";
    private static final String logFileDirProp = "com.fortify.sca.LogFileDir";
    private static final String logFileNameProp = "com.fortify.sca.LogFileName";
    private static final String logFileNameNoExtProp = "com.fortify.sca.LogFileNameNoExt";
    private static final String logFileExtProp = "com.fortify.sca.LogFileExt";
    private static final String logLevelProp = "com.fortify.sca.LogLevel";
    private static final String appendLogFileProp = "com.fortify.sca.AppendLogFile";
    private static final String logFileProp = "com.fortify.sca.LogFile";
    private LoggerConfig loggerConfig = null;
    private LoggingPrintStream outLogger = null;
    private LoggingPrintStream errLogger = null;
    private LoggerStats loggerStats = new LoggerStats();

    void updateCounts(Level level, ILoggerMin logger) {
        this.loggerStats.updateCounts(level, logger);
    }

    @Override
    public void logStatistics(ILoggerMin logger) {
        this.loggerStats.logStatistics(logger);
    }

    @Override
    public ILoggerMin getLoggerInternal(Class name) {
        if (null == name) {
            throw new IllegalArgumentException("name is null");
        }
        return new LoggerMin(name.getName());
    }

    @Override
    public ILoggerMin getLoggerInternal(String name) {
        if (null == name || name.length() == 0) {
            throw new IllegalArgumentException("name is null or empty");
        }
        return new LoggerMin(name);
    }

    @Override
    public void setLevel(Level level) {
        this.loggerConfig.level = level;
        this.setLoggerConfig(this.loggerConfig);
    }

    private static void setSystemPropertyIfNullOrEmpty(String key, String value) {
        String currentValue = System.getProperty(key);
        if (currentValue == null || currentValue.length() == 0) {
            System.setProperty(key, value);
        }
    }

    private static Pair<String, String> getFileNameAndExt(File f) {
        String name = f.getName();
        int i = name.lastIndexOf(".");
        if (-1 == i || 0 == i || name.length() - 1 == i) {
            return new Pair<String, String>(name, "");
        }
        return new Pair<String, String>(name.substring(0, i), name.substring(i));
    }

    private void populateSystemProperties(File logFile) {
        File x = logFile.getAbsoluteFile();
        LoggerFactory.setSystemPropertyIfNullOrEmpty(logFilePathProp, x.getPath());
        LoggerFactory.setSystemPropertyIfNullOrEmpty(logFileDirProp, x.getParent());
        LoggerFactory.setSystemPropertyIfNullOrEmpty(logFileNameProp, x.getName());
        this.setLogFileSysProp(x);
        Pair<String, String> fne = LoggerFactory.getFileNameAndExt(logFile);
        LoggerFactory.setSystemPropertyIfNullOrEmpty(logFileExtProp, (String)fne.second);
        LoggerFactory.setSystemPropertyIfNullOrEmpty(logFileNameNoExtProp, (String)fne.first);
        LoggerFactory.setSystemPropertyIfNullOrEmpty(logLevelProp, this.loggerConfig.level.toString());
        LoggerFactory.setSystemPropertyIfNullOrEmpty(appendLogFileProp, Boolean.toString(this.loggerConfig.appendLogFile));
        System.setProperty("log4j.isThreadContextMapInheritable", "true");
    }

    private void setLogFileSysProp(File file) {
        String path = file.getParent();
        String nameWithoutExt = (String)LoggerFactory.getFileNameAndExt((File)file).first;
        if (path != null && !path.isEmpty() && nameWithoutExt != null && !nameWithoutExt.isEmpty()) {
            String filePathWithoutExt = path + File.separator + nameWithoutExt;
            System.setProperty(logFileProp, filePathWithoutExt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoggerConfig(LoggerConfig loggerConfig) {
        this.stop();
        this.loggerConfig = loggerConfig;
        try {
            File logFile = new File(loggerConfig.filename);
            if (logFile.getParentFile() != null) {
                FileUtil.mkdirs(logFile.getParentFile());
            }
            this.populateSystemProperties(logFile);
        }
        catch (Throwable ioe) {
            ioe.printStackTrace(System.err);
        }
        finally {
            org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((boolean)false);
            if (context instanceof LoggerContext) {
                LoggerContext lc = (LoggerContext)context;
                lc.reconfigure();
            }
            if (loggerConfig.installLoggingPrintStreams) {
                this.installLoggingPrintStreams();
            }
            MessageManager.getLogger(LoggerFactory.class).log(Level.INFO, ILoggerMin.Marker.DEV, "loggerConfig:" + System.getProperty("line.separator") + this.loggerConfig.toLogString());
        }
    }

    @Override
    public LoggerConfig getLoggerConfig() {
        return this.loggerConfig;
    }

    @Override
    public void stop() {
        this.unInstallLoggingPrintStreams();
    }

    private void installLoggingPrintStreams() {
        try {
            this.outLogger = new LoggingPrintStream(defaultLoggerFactory.getLoggerInternal(LoggerFactory.class), Level.INFO, ILoggerMin.Marker.CONSOLE, "[out] ");
            System.setOut(this.outLogger);
        }
        catch (IOException ioe) {
            this.getLoggerInternal(LoggerFactory.class).log(Level.WARN, ILoggerMin.Marker.DEV, "Problem redirecting System.out", (Throwable)ioe);
        }
        try {
            this.errLogger = new LoggingPrintStream(defaultLoggerFactory.getLoggerInternal(LoggerFactory.class), Level.WARN, ILoggerMin.Marker.CONSOLE, "[err] ");
            System.setErr(this.errLogger);
        }
        catch (IOException ioe) {
            this.getLoggerInternal(LoggerFactory.class).log(Level.WARN, ILoggerMin.Marker.DEV, "Problem redirecting System.err", (Throwable)ioe);
        }
    }

    private void unInstallLoggingPrintStreams() {
        try {
            if (null != this.outLogger) {
                this.outLogger.flush();
                this.outLogger.close();
                this.outLogger.cleanup(500L);
            }
            if (null != this.errLogger) {
                this.errLogger.flush();
                this.errLogger.close();
                this.errLogger.cleanup(500L);
            }
        }
        catch (Exception t) {
            this.getLoggerInternal(LoggerFactory.class).log(Level.ERROR, ILoggerMin.Marker.DEV, "Problem unredirecting System.err or System.out", (Throwable)t);
        }
    }
}

