/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.StringBuilders;

@Plugin(name="MessageIdLayoutConverter", category="Converter")
@ConverterKeys(value={"msgid"})
public class MessageIdLayoutConverter
extends LogEventPatternConverter {
    String[] _options;

    public static MessageIdLayoutConverter newInstance(String[] options) {
        return new MessageIdLayoutConverter(options);
    }

    private MessageIdLayoutConverter(String[] options) {
        super("MsgId", "msgid");
        this._options = options;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        try {
            String msgId = (String)event.getContextData().getValue("msgId");
            if (msgId != null && !msgId.equals("-1")) {
                StringBuilders.appendValue((StringBuilder)toAppendTo, (Object)msgId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

