/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlConfigKludge {
    private XmlConfigKludge() {
    }

    private static Document loadDocument(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        return document;
    }

    private static String toString(Document document) throws Exception {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        String rval = writer.toString();
        return rval;
    }

    private static String toPrettyString(Document document) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult outputTarget = new StreamResult(writer);
        transformer.transform(new DOMSource(document), outputTarget);
        return writer.toString();
    }

    private static Element addCompositeFilter(Document document, String appenderName) throws Exception {
        String xpath = "//*[@name=\"" + appenderName + "\"]";
        NodeList nl = XmlConfigKludge.xPathQuery(document, xpath);
        Element appenderElement = (Element)nl.item(0);
        Element filtersElement = document.createElement("Filters");
        appenderElement.appendChild(filtersElement);
        return filtersElement;
    }

    private static Element addContextMapFilter(Document document, Element compositeFilterElement, String operator, Filter.Result onMatch, Filter.Result onMisMatch) {
        Element filterElement = document.createElement("ContextMapFilter");
        filterElement.setAttribute("operator", operator);
        filterElement.setAttribute("onMatch", onMatch.name());
        filterElement.setAttribute("onMisMatch", onMisMatch.name());
        compositeFilterElement.appendChild(filterElement);
        return filterElement;
    }

    private static Element addKeyValuePairElement(Document document, Element contextMapFilterElement, String key, String value) {
        Element kvpElement = document.createElement("KeyValuePair");
        kvpElement.setAttribute("key", key);
        kvpElement.setAttribute("value", value);
        contextMapFilterElement.appendChild(kvpElement);
        return kvpElement;
    }

    private static Element addMarkerFilter(Document document, Element compositeFilterElement, String marker, Filter.Result onMatch, Filter.Result onMisMatch) {
        Element filterElement = document.createElement("MarkerFilter");
        filterElement.setAttribute("marker", marker);
        filterElement.setAttribute("onMatch", onMatch.name());
        filterElement.setAttribute("onMisMatch", onMisMatch.name());
        compositeFilterElement.appendChild(filterElement);
        return compositeFilterElement;
    }

    private static void addThresholdFilter(Document document, Element compositeFilterElement, Level level, Filter.Result onMatch, Filter.Result onMisMatch) {
        Element filterElement = document.createElement("ThresholdFilter");
        filterElement.setAttribute("level", level.name());
        filterElement.setAttribute("onMatch", onMatch.name());
        filterElement.setAttribute("onMisMatch", onMisMatch.name());
        compositeFilterElement.appendChild(filterElement);
    }

    private static NodeList xPathQuery(Document document, String xPath) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression xpe = xpath.compile(xPath);
        NodeList nodeList = (NodeList)xpe.evaluate(document, XPathConstants.NODESET);
        return nodeList;
    }
}

