/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2.logger;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.logging.LoggerConfig;
import com.fortify.logging.log4j2.logger.ILoggerAbstract;
import com.fortify.messaging.MessageManager;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.FileUtil;
import com.fortify.util.InstallationConfiguration;
import com.fortify.util.SystemUtil;
import com.fortify.util.logging.EscalatingLogReceiver;
import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class DefaultLoggerImpl
extends ILoggerAbstract {
    private LoggerConfig loggerConfig = null;
    private LoggerContext loggerContext;
    private static final String logFilePathProp = "com.fortify.sca.LogFilePath";
    private static final String logFileDirProp = "com.fortify.sca.LogFileDir";
    private static final String logFileNameProp = "com.fortify.sca.LogFileName";
    private static final String logFileNameNoExtProp = "com.fortify.sca.LogFileNameNoExt";
    private static final String logFileExtProp = "com.fortify.sca.LogFileExt";
    private static final String logFileProp = "com.fortify.sca.LogFile";
    private static final String logFileContextMapInheritable = "log4j.isThreadContextMapInheritable";
    private static final String appendLogFileProp = "com.fortify.sca.AppendLogFile";
    private static ILogger log = MessageManager.getLogger(DefaultLoggerImpl.class);

    public DefaultLoggerImpl(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initLogger() {
        String level = System.getProperty("com.fortify.sca.LogLevel");
        try {
            String core;
            File logConfigFile;
            if (System.getProperty("log4j.configurationFile") == null && (logConfigFile = new File(core = SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_CORE), "config/log4j2.xml")).exists()) {
                System.setProperty("log4j.configurationFile", logConfigFile.getAbsolutePath());
            }
            System.setProperty("log4j2.loggerContextFactory", "org.apache.logging.log4j.core.impl.Log4jContextFactory");
            if (level == null || level.isEmpty()) {
                level = this.checkForLogLevelPropertiesAndSysVar(this.loggerConfig.defaultLoggerName).toString();
            }
            System.setProperty("com.fortify.sca.LogLevel", level.toString());
            File logFile = new File(this.loggerConfig.filename);
            if (logFile.getParentFile() != null) {
                FileUtil.mkdirs(logFile.getParentFile());
            }
            System.setProperty(appendLogFileProp, this.loggerConfig.appendLogFile ? "true" : "false");
            DefaultLoggerImpl.populateSystemProperties(logFile);
        }
        catch (Throwable ioe) {
            ioe.printStackTrace(System.err);
        }
        finally {
            if (this.loggerContext == null) {
                org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((boolean)false);
                if (context instanceof LoggerContext) {
                    this.loggerContext = (LoggerContext)context;
                    this.loggerContext.reconfigure();
                } else {
                    log.log(Level.WARN, ILoggerMin.Marker.DEV, "Unable to get log4j2 context");
                }
            } else {
                this.loggerContext.reconfigure();
            }
            MessageManager.addMessageReceiver(new EscalatingLogReceiver());
            if (level.equals(Level.DEBUG.toString())) {
                MessageManager.logDebug("Log4j2 configured successfully;\nlogLevel = " + level + ";\nlogToConsole = false;\nlogPath = " + InstallationConfiguration.getProductLogDirectory() + ";\nlogFileName = " + this.loggerConfig.filename + ".");
            } else {
                MessageManager.logInfo("Log4j2 configured successfully");
            }
        }
    }

    private static void populateSystemProperties(File logFile) {
        String path = logFile.getPath();
        String parent = logFile.getParent();
        String name = logFile.getName();
        System.setProperty(logFilePathProp, path);
        System.setProperty(logFileDirProp, parent);
        System.setProperty(logFileNameProp, name);
        if (path != null && !path.isEmpty() && name != null && !name.isEmpty()) {
            String fileName = name.substring(0, name.lastIndexOf("."));
            String fileExt = name.substring(name.lastIndexOf("."), name.length());
            System.setProperty(logFileProp, path + File.separator + fileName);
            System.setProperty(logFileNameNoExtProp, fileName);
            System.setProperty(logFileExtProp, fileExt == null ? "" : fileExt);
        }
        System.setProperty(logFileContextMapInheritable, "true");
    }
}

