/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2.logger;

import com.fortify.exceptions.FortifyException;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageReceiver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMessageReceiver
implements MessageReceiver {
    private Logger log;

    public DefaultMessageReceiver(Class clazz) {
        this.log = LogManager.getLogger((Class)clazz);
    }

    @Override
    public void receive(FortifyException exception) {
        if (exception.getCause() != null) {
            this.receive(exception.getFortifyMessage(), exception.getCause());
        } else {
            this.receive(exception.getFortifyMessage());
        }
    }

    @Override
    public void receive(Message message) {
        this.receive(message, null);
    }

    @Override
    public void receive(Message message, Throwable cause) {
        int code = message.getErrorCode();
        LogLevel level = LogLevel.level(message.getLogLevel().intLevel());
        switch (level) {
            case ERROR: {
                this.log.error("Error " + code + ": " + message.getLocalizedMessage() + (cause != null ? " - Caused by: " + cause.getLocalizedMessage() : ""));
                break;
            }
            case WARN: {
                this.log.warn("WARNING: " + message.getLocalizedMessage() + (cause != null ? " - Caused by: " + cause.getLocalizedMessage() : ""));
                break;
            }
            case INFO: {
                this.log.info(message.getLocalizedMessage() + (cause != null ? " - Caused by: " + cause.getLocalizedMessage() : ""));
                break;
            }
            case DEBUG: {
                this.log.debug(message.getLocalizedMessage() + (cause != null ? " - Caused by: " + cause.getLocalizedMessage() : ""));
            }
        }
    }

    private static enum LogLevel {
        ERROR(200),
        WARN(300),
        INFO(400),
        DEBUG(500);

        private int statusCode;

        private LogLevel(int code) {
            this.statusCode = code;
        }

        public static LogLevel level(int code) {
            switch (code) {
                case 200: {
                    return ERROR;
                }
                case 300: {
                    return WARN;
                }
                case 400: {
                    return INFO;
                }
                case 500: {
                    return DEBUG;
                }
            }
            return INFO;
        }
    }
}

