/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2.logger;

import com.fortify.logging.log4j2.logger.ILogger;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.SystemUtil;
import org.apache.logging.log4j.Level;

public abstract class ILoggerAbstract
implements ILogger {
    protected boolean checkConsoleLogging() {
        String console = System.getProperty(CommonPropertyKeys.PK_LOG_TO_CONSOLE.key);
        if (console == null) {
            Object value = SystemUtil.getProperties().get(CommonPropertyKeys.PK_LOG_TO_CONSOLE.key);
            console = value == null ? "false" : value.toString();
        }
        return !console.isEmpty() && !console.equalsIgnoreCase("false");
    }

    protected Level checkForLogLevelPropertiesAndSysVar(String loggerName) {
        Level level;
        switch (loggerName) {
            case "AWB": {
                level = this.checkProperty(CommonPropertyKeys.PK_LOG_LEVEL_AWB_DEBUG.key);
                level = level == null ? this.checkProperty(CommonPropertyKeys.PK_DEBUG.key) : level;
                break;
            }
            case "RemediationPlugin": {
                level = this.checkProperty(CommonPropertyKeys.PK_LOG_LEVEL_ECLIPSE_DEBUG.key);
                level = level == null ? this.checkProperty(CommonPropertyKeys.PK_DEBUG.key) : level;
                break;
            }
            case "SCAPlugin": {
                level = this.checkProperty(CommonPropertyKeys.PK_LOG_LEVEL_ECLIPSE_DEBUG.key);
                level = level == null ? this.checkProperty(CommonPropertyKeys.PK_DEBUG.key) : level;
                break;
            }
            case "IntelliJAnalysis": {
                level = this.checkProperty(CommonPropertyKeys.PK_LOG_LEVEL_ECLIPSE_DEBUG.key);
                level = level == null ? this.checkProperty(CommonPropertyKeys.PK_DEBUG.key) : level;
                break;
            }
            default: {
                level = this.checkProperty(CommonPropertyKeys.PK_DEBUG.key);
            }
        }
        return level == null ? Level.INFO : level;
    }

    protected Level checkProperty(String key) {
        String property = System.getProperty(key);
        if (property == null) {
            Object value = SystemUtil.getProperties().get(key);
            String string = property = value == null ? null : (String)value;
        }
        if (property == null || property.isEmpty()) {
            return null;
        }
        return property.equalsIgnoreCase("false") ? Level.INFO : Level.DEBUG;
    }
}

