/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.logging.log4j2.logger;

import com.fortify.logging.log4j2.logger.ILoggerAbstract;
import com.fortify.util.InstallationConfiguration;
import java.io.File;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

public class Log4j2Initializer
extends ILoggerAbstract {
    private static final Log4j2Initializer INSTANCE = new Log4j2Initializer();
    private Level level = null;
    private String loggerName = "";
    private boolean logToConsole = true;
    private String logFileName = "";
    private static final Level INTERNALLOG4J2_LEVEL = Level.WARN;
    private static final Logger log = LogManager.getLogger(Log4j2Initializer.class);

    private Log4j2Initializer() {
    }

    @Override
    public void initLogger() {
        this.level = this.level == null ? this.checkForLogLevelPropertiesAndSysVar(this.loggerName) : this.level;
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(INTERNALLOG4J2_LEVEL);
        builder.setConfigurationName("com.fortify");
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        this.logToConsole = this.checkConsoleLogging();
        if (this.logToConsole) {
            appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "[%d{yyyy-MM-dd'T'HH:mm:ss}{" + TimeZone.getDefault().getID() + "} %p] %m%n"));
            builder.add(appenderBuilder);
        }
        LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "[%d{yyyy-MM-dd'T'HH:mm:ss}{" + TimeZone.getDefault().getID() + "} %p] %m%n");
        ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "100M"));
        appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("rolling", "RollingFile").addAttribute("fileName", InstallationConfiguration.getProductLogDirectory() + File.separator + this.logFileName)).addAttribute("filePattern", InstallationConfiguration.getProductLogDirectory() + File.separator + "archive" + File.pathSeparator + this.logFileName + "-%d{MM-dd-yy}.log.gz")).add(layoutBuilder).addAttribute("append", true)).addComponent(triggeringPolicy);
        builder.add(appenderBuilder);
        LoggerComponentBuilder confComFortifyLogger = builder.newLogger("com.fortify", this.level);
        confComFortifyLogger.add(builder.newAppenderRef("rolling"));
        if (this.logToConsole) {
            confComFortifyLogger.add(builder.newAppenderRef("Stdout"));
        }
        confComFortifyLogger.addAttribute("additivity", false);
        builder.add(confComFortifyLogger);
        RootLoggerComponentBuilder confRootLogger = builder.newRootLogger(this.level);
        confRootLogger.add(builder.newAppenderRef("rolling"));
        if (this.logToConsole) {
            confRootLogger.add(builder.newAppenderRef("Stdout"));
        }
        confRootLogger.addAttribute("additivity", false);
        builder.add(confRootLogger);
        Configuration conf = (Configuration)builder.build();
        conf.start();
        org.apache.logging.log4j.spi.LoggerContext context = LogManager.getContext((boolean)false);
        if (context instanceof LoggerContext) {
            LoggerContext ctx = (LoggerContext)context;
            Configuration config = ctx.getConfiguration();
            config.addLogger("com.fortify", (LoggerConfig)conf.getLoggers().get("com.fortify"));
            config.addLogger(conf.getRootLogger().getName(), conf.getRootLogger());
            ctx.updateLoggers();
        } else {
            log.log(Level.WARN, "Unable to get log4j2 context");
        }
        if (this.level.equals((Object)Level.DEBUG)) {
            log.log(Level.DEBUG, "Log4j2 configured successfully;\nlogLevel = " + this.level + ";\nlogToConsole = " + this.logToConsole + ";\nlogPath = " + InstallationConfiguration.getProductLogDirectory() + ";\nlogFileName = " + this.logFileName + ".\n");
        } else {
            log.log(Level.INFO, "Log4j2 configured successfully");
        }
    }

    public static Builder getBuilder() {
        Log4j2Initializer log4j2Initializer = INSTANCE;
        Objects.requireNonNull(log4j2Initializer);
        return log4j2Initializer.new Builder();
    }

    public class Builder {
        private Builder() {
        }

        public Builder setLevel(Level level) {
            Log4j2Initializer.this.level = level;
            return this;
        }

        public Builder setDebugLevel(boolean debug) {
            Log4j2Initializer.this.level = debug ? Level.DEBUG : Level.INFO;
            return this;
        }

        public Builder setLoggerName(String loggerName) {
            Log4j2Initializer.this.loggerName = loggerName;
            return this;
        }

        public Builder setLogFileName(String logFileName) {
            Log4j2Initializer.this.logFileName = logFileName;
            return this;
        }

        public Log4j2Initializer build() {
            if (Log4j2Initializer.this.logFileName == null || Log4j2Initializer.this.logFileName.isEmpty()) {
                throw new IllegalArgumentException("Log file name is null or empty, logFileName value should be initialized");
            }
            return Log4j2Initializer.this;
        }
    }
}

