/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.messaging;

import com.fortify.messaging.LocalizationDelegate;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.util.SystemUtil;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Localization {
    private static final String DEFAULT_LOCALIZATION_BUNDLE_NAME = "FortifyMessages";
    public static final String DEFAULT_LOCALIZATION_BUNDLE = "messages/FortifyMessages";
    private static LocalizationDelegate localizationDelegate;
    private static Map<String, ResourceBundle[]> localizationBundlesMap;

    private static synchronized Map<String, ResourceBundle[]> getLocalizationBundlesMap() {
        if (localizationBundlesMap == null) {
            localizationBundlesMap = new LinkedHashMap<String, ResourceBundle[]>();
        }
        return localizationBundlesMap;
    }

    public static void setLocalizationDelegate(LocalizationDelegate localizationDelegate) {
        Localization.localizationDelegate = localizationDelegate;
        Logger log = LogManager.getLogger((String)MessageManager.class.toString());
        log.debug((Object)log);
    }

    public static void addResourceBundle(ResourceBundle bundle) {
        Localization.addResourceBundle(bundle, DEFAULT_LOCALIZATION_BUNDLE);
    }

    public static void addResourceBundle(ResourceBundle bundle, String bundleName) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        ResourceBundle[] localizationBundles = Localization.getLocalizationBundlesMap().get(bundleName);
        if (localizationBundles == null) {
            localizationBundles = new ResourceBundle[]{bundle};
        } else {
            ResourceBundle[] localizationBundlestmp = new ResourceBundle[localizationBundles.length + 1];
            System.arraycopy(localizationBundles, 0, localizationBundlestmp, 0, localizationBundles.length);
            localizationBundlestmp[localizationBundles.length] = bundle;
            localizationBundles = localizationBundlestmp;
        }
        Localization.getLocalizationBundlesMap().put(bundleName, localizationBundles);
    }

    public static void addResourceBundle(String bundleName) throws MissingResourceException {
        Localization.addResourceBundle(bundleName, SystemUtil.getFortifyLocale());
    }

    public static void addResourceBundle(String bundleName, Locale locale) throws MissingResourceException {
        ResourceBundle newBundle;
        try {
            newBundle = ResourceBundle.getBundle("messages/" + bundleName, locale);
        }
        catch (MissingResourceException mre) {
            newBundle = ResourceBundle.getBundle(bundleName, locale);
        }
        Localization.addResourceBundle(newBundle, bundleName);
    }

    public static String getLocalizedMessage(String key, String bundleName) {
        String msg = null;
        if (localizationDelegate != null) {
            msg = localizationDelegate.getMessage(key);
        }
        if (msg != null) {
            return msg;
        }
        ResourceBundle[] localizationBundles = Localization.getLocalizationBundlesMap().get(bundleName);
        if (localizationBundles != null) {
            for (int i = 0; i < localizationBundles.length; ++i) {
                try {
                    msg = localizationBundles[i].getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (msg == null) continue;
                return msg;
            }
        }
        return "UNKNOWN_MESSAGE : " + key;
    }

    public static String getLocalString(int messageCode, Object ... params) {
        Message m = new Message(1, messageCode, params);
        return m.getLocalizedMessage();
    }

    public static String getLocalString(String bundleName, int messageCode, Object ... params) {
        Message m = new Message(1, messageCode, params);
        return m.getLocalizedMessage(bundleName);
    }

    static String getLocalizedMessage(String key) {
        String msg = null;
        if (localizationDelegate != null) {
            msg = localizationDelegate.getMessage(key);
        }
        if (msg != null) {
            return msg;
        }
        for (ResourceBundle[] localizationBundles : Localization.getLocalizationBundlesMap().values()) {
            for (int i = 0; i < localizationBundles.length; ++i) {
                try {
                    msg = localizationBundles[i].getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (msg == null) continue;
                return msg;
            }
        }
        return "UNKNOWN_MESSAGE : " + key;
    }

    static {
        try {
            ResourceBundle defaultBundle = ResourceBundle.getBundle(DEFAULT_LOCALIZATION_BUNDLE);
            Localization.getLocalizationBundlesMap().put(DEFAULT_LOCALIZATION_BUNDLE_NAME, new ResourceBundle[]{defaultBundle});
        }
        catch (MissingResourceException mre) {
            System.err.println("Unable to locate ResourceBundle messages/FortifyMessages");
            Localization.getLocalizationBundlesMap().put(DEFAULT_LOCALIZATION_BUNDLE_NAME, new ResourceBundle[0]);
        }
    }
}

