/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.messaging;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.logging.log4j2.LoggerFactory;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.util.Supplier;

public class Logger
implements ILogger {
    private String name;
    private ILoggerMin logger;

    public String toString() {
        return this.name;
    }

    Logger(String name) {
        this.name = name;
        this.logger = LoggerFactory.defaultLoggerFactory.getLoggerInternal(name);
    }

    public ILoggerMin getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void send(Message m) {
        this.sendInt(m);
    }

    @Override
    public void handleException(Message m, Throwable throwable) {
        this.handleExceptionInt(m, throwable);
    }

    @Override
    public void handleException(FortifyException fortifyException) {
        this.handleExceptionInt(fortifyException);
    }

    private void sendInt(Message m) {
        m.loggerName = this.name;
        this.mapLevelMarkerSeverity(m);
        MessageManager.sendDispatch(m);
    }

    private void handleExceptionInt(Message m, Throwable throwable) {
        m.loggerName = this.name;
        this.mapLevelMarkerSeverity(m);
        MessageManager.handleExceptionDispatch(m, throwable);
    }

    private void handleExceptionInt(FortifyException fortifyException) {
        fortifyException.getFortifyMessage().loggerName = this.name;
        this.mapLevelMarkerSeverity(fortifyException.getFortifyMessage());
        MessageManager.handleExceptionDispatch(fortifyException);
    }

    @Override
    public void log(Level level, Marker marker, String message, Throwable throwable) {
        Message m = new Message(-1, level, 0, marker, throwable, message, null, null, null);
        this.handleExceptionInt(m, throwable);
    }

    @Override
    public void log(Level level, Marker marker, String message, Throwable throwable, Object ... params) {
        Message m = new Message(-1, level, 0, marker, throwable, message, null, null, params);
        this.handleExceptionInt(m, throwable);
    }

    @Override
    public void log(Level level, Marker marker, int msgId, Throwable throwable, Object ... params) {
        Message m = new Message(msgId, level, 0, marker, throwable, null, null, null, params);
        this.handleExceptionInt(m, throwable);
    }

    @Override
    public void log(Level level, Marker marker, String message, Throwable throwable, Supplier<?> ... params) {
        Message m = new Message(-1, level, 0, marker, throwable, message, null, params, null);
        this.handleExceptionInt(m, throwable);
    }

    @Override
    public void log(Level level, Marker marker, int msgId, Throwable throwable, Supplier<?> ... params) {
        Message m = new Message(msgId, level, 0, marker, throwable, null, null, params, null);
        this.handleExceptionInt(m, throwable);
    }

    public void log(Level level, Marker marker, Supplier supplier, Throwable throwable) {
        Message m = new Message(-1, level, 0, marker, throwable, null, supplier, null, null);
        this.handleExceptionInt(m, throwable);
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.getLogger().isEnabled(level);
    }

    void mapLevelMarkerSeverity(Message msg) {
        Marker marker = msg.getMarker();
        if (marker == null || marker == ILoggerMin.Marker.DEV || marker == ILoggerMin.Marker.USER) {
            return;
        }
        if (marker == ILoggerMin.Marker.LOG) {
            msg.setLevel(ILoggerMin.Level.DEBUG);
            msg.setSeverity(5);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.LOG_VERBOSE) {
            msg.setLevel(ILoggerMin.Level.TRACE);
            msg.setSeverity(9);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.LOG_STATUS) {
            msg.setLevel(ILoggerMin.Level.INFO);
            msg.setSeverity(10);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.LOG_VERBOSE) {
            msg.setLevel(ILoggerMin.Level.TRACE);
            msg.setSeverity(9);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.ERROR) {
            msg.setLevel(ILoggerMin.Level.ERROR);
            msg.setSeverity(4);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.WARNING) {
            msg.setLevel(ILoggerMin.Level.WARN);
            msg.setSeverity(3);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.INFO) {
            msg.setLevel(ILoggerMin.Level.INFO);
            msg.setSeverity(1);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.VERBOSE) {
            msg.setLevel(ILoggerMin.Level.INFO);
            msg.setSeverity(2);
            msg.setMarker(null);
        } else if (marker == ILoggerMin.Marker.WARN_INTERNAL) {
            msg.setLevel(ILoggerMin.Level.WARN);
            msg.setSeverity(6);
            msg.setMarker(null);
        }
    }

    @Override
    public void log(Level level, Marker marker, Supplier<?> supplier) {
        Message m = new Message(-1, level, 0, marker, null, null, supplier, null, null);
        this.sendInt(m);
    }

    @Override
    public void log(Level level, Marker marker, String message, Supplier<?> ... suppliers) {
        Message m = new Message(-1, level, 0, marker, null, message, null, suppliers, null);
        this.sendInt(m);
    }

    @Override
    public void log(Level level, Marker marker, int msgId, Supplier<?> ... suppliers) {
        Message m = new Message(msgId, level, 0, marker, null, null, null, suppliers, null);
        this.sendInt(m);
    }

    @Override
    public void log(Level level, Marker marker, String message) {
        Message m = new Message(-1, level, 0, marker, null, message, null, null, null);
        this.sendInt(m);
    }

    @Override
    public void log(Level level, Marker marker, String message, Object ... params) {
        Message m = new Message(-1, level, 0, marker, null, message, null, null, params);
        this.sendInt(m);
    }

    @Override
    public void log(Level level, Marker marker, int errorCode, Object ... params) {
        Message m = new Message(errorCode, level, 0, marker, null, null, null, null, params);
        this.sendInt(m);
    }

    @Override
    public void log(Level level, Marker marker, int errorCode) {
        Message m = new Message(errorCode, level, 0, marker, null, null, null, null, null);
        this.sendInt(m);
    }
}

