/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.messaging;

import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.FortifyMessageHolder;
import com.fortify.messaging.Localization;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.util.Supplier;

public class Message
implements Serializable,
FortifyMessageHolder {
    public static final int NONE = 0;
    public static final int INFORMATIONAL = 1;
    public static final int INFO_VERBOSE = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int LOG = 5;
    public static final int INTERNAL_WARNING = 6;
    public static final int EXCEPTION = 7;
    public static final int BUG = 8;
    public static final int LOG_VERBOSE = 9;
    public static final int LOG_STATUS = 10;
    public static final int DEFAULT_ERROR_CODE = -1;
    private static String[] _severityToString = new String[]{"NONE", "INFORMATIONAL", "INFO_VERBOSE", "WARNING", "ERROR", "LOG", "INTERNAL_WARNING", "EXCEPTION", "BUG", "LOG_VERBOSE", "LOG_STATUS"};
    public String loggerName;
    private Level level;
    private Marker marker;
    private Throwable throwable;
    private String message;
    private String parameterizedMessage;
    private Supplier<?> supplier;
    private Object[] parameters;
    Supplier<?>[] suppliers;
    private int severity;
    private final int errorCode;
    private static final String HEX = "0123456789abcdef";

    public static String getSeverityString(int severity) {
        return _severityToString[severity];
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Supplier<?>[] getSuppliers() {
        return this.suppliers;
    }

    public Supplier<?> getSupplier() {
        return this.supplier;
    }

    public boolean hasErrorCode() {
        return this.errorCode != -1;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public Message(int errorCode, Level level, int severity, Marker marker, Throwable throwable, String message, Supplier supplier, Supplier<?>[] suppliers, Object[] parameters) {
        this.level = level;
        this.marker = marker;
        this.throwable = throwable;
        this.message = message;
        this.supplier = supplier;
        this.suppliers = suppliers;
        this.parameters = parameters;
        this.severity = severity;
        this.errorCode = errorCode;
        if (this.suppliers != null) {
            this.parameters = null;
        }
    }

    public Message(int severity, String message) {
        this(-1, Level.OFF, severity, null, null, message, null, null, null);
    }

    public Message(int severity, int errorCode, Object ... parameters) {
        this(errorCode, Level.OFF, severity, null, null, null, null, null, parameters);
    }

    public Message(int severity, String message, Object ... parameters) {
        this(-1, Level.OFF, severity, null, null, message, null, null, parameters);
    }

    public String getMessage(String bundleName) {
        if (null == this.message) {
            if (this.hasErrorCode()) {
                this.message = bundleName == null ? Localization.getLocalizedMessage(Integer.toString(this.errorCode)) : Localization.getLocalizedMessage(Integer.toString(this.errorCode), bundleName);
            } else if (null != this.supplier) {
                this.message = this.supplier.get().toString();
            }
        }
        return this.message;
    }

    public String getMessage() {
        return this.getMessage(null);
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(null);
    }

    public String getLocalizedMessage(String bundleName) {
        if (null == this.parameterizedMessage) {
            String msg = this.getMessage(bundleName);
            this.parameterizedMessage = this.parameterize(msg);
        }
        return this.parameterizedMessage;
    }

    public String getSymbolicMessage() {
        StringBuffer buf = new StringBuffer();
        this.getSymbolicMessage(buf);
        return buf.toString();
    }

    public Object[] getParameters() {
        this.convertSuppliersToParameters();
        return this.parameters;
    }

    public void getSymbolicMessage(StringBuffer buf) {
        if (this.hasErrorCode()) {
            buf.append(this.errorCode);
        } else {
            Message.quote(buf, this.getMessage());
        }
        this.convertSuppliersToParameters();
        if (null == this.parameters || this.parameters.length == 0) {
            return;
        }
        buf.append('(');
        String sep = "";
        for (Object parameter : this.parameters) {
            buf.append(sep);
            if (parameter == null) {
                buf.append("null");
            } else if (parameter instanceof Message) {
                ((Message)parameter).getSymbolicMessage(buf);
            } else {
                Message.quote(buf, parameter.toString());
            }
            sep = ",";
        }
        buf.append(')');
    }

    private static void quote(StringBuffer buf, String s) {
        buf.append("'");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                buf.append('\'');
                buf.append('\'');
                continue;
            }
            if (c < ' ' || c > '~') {
                buf.append('\'');
                buf.append('#');
                Message.hex(buf, c);
                buf.append('\'');
                continue;
            }
            buf.append(c);
        }
    }

    private static void hex(StringBuffer buf, char c) {
        char v = c;
        if (v > '\u00ff') {
            buf.append(HEX.charAt(v >> 12));
            buf.append(HEX.charAt(v >> 8 & 0xF));
        }
        buf.append(HEX.charAt(v >> 4 & 0xF));
        buf.append(HEX.charAt(v & 0xF));
    }

    public String toString() {
        return this.getLocalizedMessage();
    }

    public Level getLogLevel() {
        if (this.level != Level.OFF) {
            return this.level;
        }
        switch (this.severity) {
            case 0: {
                return Level.ALL;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.INFO;
            }
            case 3: {
                return Level.WARN;
            }
            case 4: {
                return Level.ERROR;
            }
            case 5: {
                return Level.DEBUG;
            }
            case 6: {
                return Level.WARN;
            }
            case 7: {
                return Level.ERROR;
            }
            case 8: {
                return Level.ERROR;
            }
            case 9: {
                return Level.TRACE;
            }
            case 10: {
                return Level.INFO;
            }
        }
        return Level.WARN;
    }

    public Marker getMarker() {
        if (this.marker != null) {
            return this.marker;
        }
        if (this.errorCode == -1) {
            return ILoggerMin.Marker.DEV;
        }
        return ILoggerMin.Marker.USER;
    }

    @Override
    public Message getFortifyMessage() {
        return this;
    }

    private void convertSuppliersToParameters() {
        if (null != this.parameters) {
            return;
        }
        if (null != this.suppliers) {
            Object[] lparameters = new Object[this.suppliers.length];
            int i = 0;
            for (Supplier<?> s : this.suppliers) {
                Object value = s.get();
                lparameters[i++] = value;
            }
            this.parameters = lparameters;
        }
    }

    private String parameterize(String msg) {
        if (msg == null) {
            return "";
        }
        this.convertSuppliersToParameters();
        if (null == this.parameters || this.parameters.length == 0) {
            return msg;
        }
        StringBuffer result = new StringBuffer();
        int segStart = 0;
        while (true) {
            String val;
            int segEnd;
            if ((segEnd = msg.indexOf("${", segStart)) == -1) {
                result.append(msg.substring(segStart));
                break;
            }
            int varEnd = msg.indexOf(125, segEnd);
            if (varEnd == -1) {
                result.append(msg.substring(segEnd));
                break;
            }
            result.append(msg.substring(segStart, segEnd));
            String var = msg.substring(segEnd + 2, varEnd);
            try {
                int pno = Integer.parseInt(var);
                Object param = this.parameters[pno];
                val = param == null ? "(?)" : (param instanceof Message ? ((Message)param).getLocalizedMessage() : param.toString());
            }
            catch (NumberFormatException nfe) {
                val = "${" + var + "}";
            }
            catch (IndexOutOfBoundsException aie) {
                val = "(?)";
            }
            result.append(val);
            segStart = varEnd + 1;
        }
        return result.toString();
    }

    public static Message mk(int ec) {
        return new Message(0, ec, (Object[])null);
    }

    public static Message mk(int ec, Object ... params) {
        return new Message(0, ec, params);
    }
}

