/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.messaging;

import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.logging.log4j2.LevelAdjuster;
import com.fortify.messaging.Localization;
import com.fortify.messaging.LocalizationDelegate;
import com.fortify.messaging.Logger;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManagerEscapeException;
import com.fortify.messaging.MessageReceiver;
import com.fortify.messaging.MessageSuppressor;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class MessageManager {
    private static final Set<MessageReceiver> receivers = new LinkedHashSet<MessageReceiver>();
    private static ILogger messageManagerLogger = MessageManager.getLogger(MessageManager.class);
    private static MessageSuppressor messageSuppressor = new MessageSuppressor(true);
    private static LevelAdjuster levelAdjuster = new LevelAdjuster();

    public static LevelAdjuster getLevelAdjuster() {
        return levelAdjuster;
    }

    public static MessageSuppressor getMessageSuppressor() {
        return messageSuppressor;
    }

    public static ILogger getLogger(Class c) {
        if (null == c) {
            throw new IllegalArgumentException("class is null");
        }
        return new Logger(c.getName());
    }

    public static void setLocalizationDelegate(LocalizationDelegate localizationDelegate) {
        Localization.setLocalizationDelegate(localizationDelegate);
    }

    private MessageManager() {
    }

    public static void addMessageReceiver(MessageReceiver receiver) {
        receivers.add(receiver);
    }

    public static void removeMessageReceiver(MessageReceiver receiver) {
        receivers.remove(receiver);
    }

    static void sendDispatch(Message message) {
        if (messageSuppressor.shouldSuppress(message.getErrorCode())) {
            return;
        }
        message.setLevel(levelAdjuster.adjust(message.getErrorCode(), message.getFortifyMessage().getLogLevel()));
        for (MessageReceiver rcvr : receivers) {
            try {
                rcvr.receive(message);
            }
            catch (RuntimeException re) {
                if (!(re instanceof MessageManagerEscapeException)) continue;
                throw re;
            }
            catch (Throwable throwable) {
            }
        }
    }

    static void handleExceptionDispatch(FortifyException e) {
        if (messageSuppressor.shouldSuppress(e.getFortifyMessage().getErrorCode())) {
            return;
        }
        e.getFortifyMessage().setLevel(levelAdjuster.adjust(e.getFortifyMessage().getErrorCode(), e.getFortifyMessage().getLogLevel()));
        for (MessageReceiver rcvr : receivers) {
            try {
                rcvr.receive(e);
            }
            catch (RuntimeException re) {
                if (!(re instanceof MessageManagerEscapeException)) continue;
                throw re;
            }
            catch (Throwable throwable) {
            }
        }
    }

    static void handleExceptionDispatch(Message message, Throwable cause) {
        if (messageSuppressor.shouldSuppress(message.getErrorCode())) {
            return;
        }
        message.setLevel(levelAdjuster.adjust(message.getErrorCode(), message.getFortifyMessage().getLogLevel()));
        for (MessageReceiver rcvr : receivers) {
            try {
                rcvr.receive(message, cause);
            }
            catch (RuntimeException re) {
                if (!(re instanceof MessageManagerEscapeException)) continue;
                throw re;
            }
            catch (Throwable throwable) {
            }
        }
    }

    public static void send(Message m) {
        messageManagerLogger.send(m);
    }

    public static void handleException(Message m, Throwable throwable) {
        messageManagerLogger.handleException(m, throwable);
    }

    public static void handleException(FortifyException fortifyException) {
        messageManagerLogger.handleException(fortifyException);
    }

    public static String getLocalString(int messageCode, Object ... params) {
        Message m = new Message(1, messageCode, params);
        return m.getLocalizedMessage();
    }

    public static String getLocalString(String bundleName, int messageCode, Object ... params) {
        Message m = new Message(1, messageCode, params);
        return m.getLocalizedMessage(bundleName);
    }

    public static void addResourceBundle(ResourceBundle bundle) {
        Localization.addResourceBundle(bundle);
    }

    public static void addResourceBundle(ResourceBundle bundle, String bundleName) {
        Localization.addResourceBundle(bundle, bundleName);
    }

    public static void addResourceBundle(String bundleName) throws MissingResourceException {
        Localization.addResourceBundle(bundleName);
    }

    public static void addResourceBundle(String bundleName, Locale locale) throws MissingResourceException {
        Localization.addResourceBundle(bundleName, locale);
    }

    public static void logDebug(String msg) {
        messageManagerLogger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.USER, msg);
    }

    public static void logInfo(String msg) {
        messageManagerLogger.log(ILoggerMin.Level.INFO, ILoggerMin.Marker.USER, msg);
    }

    public static void logTrace(String msg) {
        messageManagerLogger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.USER, msg);
    }

    public static void logWarn(String msg) {
        messageManagerLogger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.USER, msg);
    }

    public static void logWarn(String msg, Throwable throwable) {
        messageManagerLogger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.DEV, msg, throwable);
    }

    public static void logError(String msg, Throwable throwable) {
        messageManagerLogger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.DEV, msg, throwable);
    }

    public static void logError(String msg) {
        messageManagerLogger.log(ILoggerMin.Level.ERROR, ILoggerMin.Marker.DEV, msg);
    }
}

