/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.messaging;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public class MessageSuppressor {
    private static ILogger logger = MessageManager.getLogger(MessageSuppressor.class);
    private boolean logLimitReached;
    private final HashMap<Integer, MsgIdEntry> entries = new HashMap();

    public MessageSuppressor(boolean logLimitReached) {
        this.logLimitReached = logLimitReached;
    }

    public void logStatistics(ILogger logger, boolean detailed) {
        String lineSeparator = System.getProperty("line.separator");
        if (logger == null) {
            logger = MessageSuppressor.logger;
        }
        StringBuilder sb = new StringBuilder("message id statistics:").append(lineSeparator);
        for (MsgIdEntry me : this.entries.values()) {
            me.toLogString(sb, detailed);
        }
        logger.log(Level.INFO, ILoggerMin.Marker.DEV, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldSuppress(int msgId) {
        HashMap<Integer, MsgIdEntry> hashMap = this.entries;
        synchronized (hashMap) {
            MsgIdEntry me = this.entries.get(msgId);
            if (null == me) {
                me = this.addSuppression(msgId, null, -1);
            }
            ++me.totalCount;
            if (me.limit == -1) {
                return false;
            }
            String key = MessageSuppressor.makeKey(me.scope);
            LimitEntry le = me.limitEntries.get(key);
            if (null == le) {
                le = new LimitEntry();
                le.scopeKey = key;
                me.limitEntries.put(key, le);
            }
            ++le.count;
            if (le.count > me.limit) {
                ++le.suppressedCount;
                ++me.totalSupressedCount;
                if (this.logLimitReached) {
                    logger.log(Level.WARN, ILoggerMin.Marker.DEV, "messageID:{} suppression limit {} reached key:{}", me.msgId, me.limit, key);
                }
                return true;
            }
            return false;
        }
    }

    private static String makeKey(String[] scopeKey) {
        if (null == scopeKey || scopeKey.length == 0) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("key:");
        for (String contextKey : scopeKey) {
            String contextValue = ThreadContext.get((String)contextKey);
            if (null == contextValue) {
                contextValue = "null";
            }
            sb.append('(').append(contextKey).append(':').append(contextValue).append(')').append(',');
        }
        return sb.toString();
    }

    public int load(File file) {
        int rval = 0;
        file = file.getAbsoluteFile();
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode actualObj = mapper.readTree(file);
            for (JsonNode node : actualObj) {
                try {
                    int id = node.path("id").asInt();
                    int limit = node.path("limit").asInt();
                    ArrayList<String> cl = new ArrayList<String>();
                    for (JsonNode contextKey : node.path("scope")) {
                        String keyName = contextKey.asText();
                        cl.add(keyName);
                    }
                    String[] ca = cl.toArray(new String[0]);
                    this.addSuppression(id, ca, limit);
                    ++rval;
                }
                catch (Exception e) {
                    logger.log(Level.ERROR, ILoggerMin.Marker.DEV, String.format("swallowing exception processing element '%s'", node.asText()), (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.INFO, ILoggerMin.Marker.DEV, String.format("message suppression file not found %s", file.getAbsolutePath().toString()));
        }
        catch (Exception e) {
            logger.log(Level.WARN, ILoggerMin.Marker.DEV, String.format("swallowing exception loading message suppression file:%s", file.getAbsolutePath().toString()), (Throwable)e);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgIdEntry addSuppression(int msgId, String[] scopeKey, int limit) {
        HashMap<Integer, MsgIdEntry> hashMap = this.entries;
        synchronized (hashMap) {
            MsgIdEntry me = new MsgIdEntry(msgId, scopeKey, limit);
            this.entries.put(msgId, me);
            return me;
        }
    }

    class MsgIdEntry {
        final int msgId;
        final String[] scope;
        final int limit;
        final HashMap<String, LimitEntry> limitEntries;
        int totalCount;
        int totalSupressedCount;

        MsgIdEntry(int msgId, String[] scope, int limit) {
            this.msgId = msgId;
            this.scope = scope == null ? new String[0] : scope;
            this.limit = limit;
            this.limitEntries = new HashMap();
            this.totalCount = 0;
            this.totalSupressedCount = 0;
        }

        StringBuilder toLogString(StringBuilder sb, boolean detailed) {
            String lineSeparator = System.getProperty("line.separator");
            sb.append("   id:").append(String.format("%10d", this.msgId)).append(" total:").append(String.format("%10d", this.totalCount)).append(" totalSuppressedCount:").append(String.format("%10d", this.totalSupressedCount)).append(" scope:[");
            for (String k : this.scope) {
                sb.append(k).append(",");
            }
            sb.append("]").append(lineSeparator);
            if (detailed) {
                for (LimitEntry le : this.limitEntries.values()) {
                    sb.append("      count:").append(String.format("%10d", le.count)).append(" suppressedCount:").append(String.format("%10d", le.suppressedCount)).append(" scopeKey:").append(le.scopeKey).append(lineSeparator);
                }
            }
            return sb;
        }
    }

    class LimitEntry {
        String scopeKey = null;
        int count = 0;
        int suppressedCount = 0;

        LimitEntry() {
        }
    }
}

