/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.rules;

import com.fortify.rules.RuleExclusion;
import com.fortify.rules.RuleIdObject;
import com.fortify.rules.RuleMask;
import com.fortify.rules.RuleMetaInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RuleMaskable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_INPUTSOURCE = 11;
    public static final int TYPE_ANALYZER = 21;
    public static final int TYPE_CATEGORY = 22;
    public static final int TYPE_SUBCATEGORY = 23;
    public static final int TYPE_PACKAGE = 24;
    public static final int TYPE_RULEID = 31;
    public static final String NAME_INPUTSOURCE = "inputsource";
    public static final String NAME_ANALYZER = "analyzer";
    public static final String NAME_CATEGORY = "category";
    public static final String NAME_SUBCATEGORY = "subcategory";
    public static final String NAME_PACKAGE = "package";
    public static final String NAME_RULEID = "ruleid";
    public static final String NAME_ANALYZER_INTERNAL = "internal";
    public static final String NAME_ANALYZER_DATAFLOW = "dataflow";
    public static final String NAME_ANALYZER_SEMANTIC = "semantic";
    public static final String NAME_ANALYZER_CONTROLFLOW = "controlflow";
    public static final String NAME_ANALYZER_CONFIGURATION = "configuration";
    public static final String NAME_ANALYZER_STRUCTURAL = "structural";
    private static int s_seqLock = 0;
    private static int s_idSeq = 0;
    private int type = 0;
    private int id = 0;
    private String name = null;
    private boolean masked = false;
    private RuleIdObject rido = new RuleIdObject(null, null, null, null);
    private List m_children = new ArrayList();

    private static synchronized int getNextIDSeq() {
        return ++s_idSeq;
    }

    protected static synchronized void registerSeqLock() {
        if (s_seqLock == 0) {
            s_idSeq = 0;
        }
        ++s_seqLock;
    }

    protected static synchronized void unregisterSeqLock() {
        --s_seqLock;
    }

    public RuleMaskable() {
        this.id = RuleMaskable.getNextIDSeq();
    }

    public int getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int newVal) {
        this.type = newVal;
    }

    public String getTypeName() {
        switch (this.type) {
            case 11: {
                return NAME_INPUTSOURCE;
            }
            case 21: {
                return NAME_ANALYZER;
            }
            case 22: {
                return NAME_CATEGORY;
            }
            case 23: {
                return NAME_SUBCATEGORY;
            }
            case 24: {
                return NAME_PACKAGE;
            }
            case 31: {
                return NAME_RULEID;
            }
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newVal) {
        this.name = newVal;
    }

    public RuleIdObject getRIDO() {
        return this.rido;
    }

    public void setRIDO(RuleIdObject rido) {
        this.rido = rido;
    }

    public boolean getMasked() {
        return this.masked;
    }

    public void setMasked(boolean newVal) {
        this.masked = newVal;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.m_children);
    }

    public RuleMaskable addChildren(RuleMaskable rm) {
        if (this.type == 0 && rm.getType() % 10 == 1 || rm.getType() - this.type >= 1) {
            RuleMaskable curr2 = null;
            for (RuleMaskable curr2 : this.m_children) {
                if (curr2.getType() != rm.getType() || !(curr2.getType() == 31 ? curr2.getRIDO().equals(rm.getRIDO()) : curr2.getName().equalsIgnoreCase(rm.getName()))) continue;
                return curr2;
            }
            this.m_children.add(rm);
        } else {
            System.out.println("RuleMaskable.addChildren: level constraint violated");
        }
        return rm;
    }

    public void reset() {
        this.setMasked_subtree(false);
    }

    public void setMasked_subtree(boolean newVal) {
        this.masked = newVal;
        RuleMaskable curr2 = null;
        for (RuleMaskable curr2 : this.m_children) {
            curr2.setMasked_subtree(newVal);
        }
    }

    public void applyExclusion(RuleExclusion exc) {
        if (this.type == 0) {
            RuleMetaInfo tempRMI = new RuleMetaInfo();
            this.applyExclusionImpl(exc, tempRMI);
        }
    }

    protected void applyExclusionImpl(RuleExclusion exc, RuleMetaInfo rmi) {
        if (this.type != 0) {
            rmi.addAttribute(this.getTypeName(), this.name);
        }
        if (exc.getRIDO() == null || exc.getRIDO().getRuleId() == null || exc.getRIDO().getPackageName() == null && exc.getRIDO().getClassName() == null && exc.getRIDO().getMethodName() == null) {
            if (exc.isRuleExcluded(rmi)) {
                this.setMasked_subtree(true);
            } else {
                RuleMaskable curr2 = null;
                for (RuleMaskable curr2 : this.m_children) {
                    RuleMetaInfo newRMI = (RuleMetaInfo)rmi.clone();
                    curr2.applyExclusionImpl(exc, newRMI);
                }
            }
        }
    }

    public void collapse(RuleMask target, RuleExclusion parentRE) {
        RuleExclusion newRE = parentRE;
        if (this.type != 0) {
            newRE = (RuleExclusion)parentRE.clone();
            newRE.addAttribute(this.getTypeName(), this.name);
            if (this.type == 31) {
                newRE.setRIDO(this.getRIDO());
            }
        }
        if (this.m_children.size() == 0 && this.masked) {
            target.addExclusion(newRE);
        } else {
            RuleMaskable curr2 = null;
            for (RuleMaskable curr2 : this.m_children) {
                curr2.collapse(target, newRE);
            }
        }
    }

    public void applyNewMask(Set unmaskedIDs) {
        this.masked = !unmaskedIDs.contains(new Integer(this.id));
        RuleMaskable curr2 = null;
        for (RuleMaskable curr2 : this.m_children) {
            curr2.applyNewMask(unmaskedIDs);
        }
    }

    public void applyNewMask_RuleIDs(Set excludedRuleIDs) {
        if (this.type == 0) {
            List children = this.getChildren();
            Iterator cit = children.iterator();
            RuleMaskable currChild = null;
            while (cit.hasNext()) {
                currChild = (RuleMaskable)cit.next();
                if (currChild.getType() != 31) continue;
                if (excludedRuleIDs.contains(currChild.getRIDO())) {
                    currChild.setMasked(true);
                    excludedRuleIDs.remove(currChild.getRIDO());
                    continue;
                }
                currChild.setMasked(false);
            }
            if (excludedRuleIDs.size() > 0) {
                Iterator eit = excludedRuleIDs.iterator();
                RuleIdObject currRido = null;
                RuleMaskable newChild = null;
                while (eit.hasNext()) {
                    currRido = (RuleIdObject)eit.next();
                    newChild = new RuleMaskable();
                    newChild.setType(31);
                    newChild.setName(currRido.getRuleId());
                    newChild.setRIDO(currRido);
                    newChild.setMasked(true);
                    this.addChildren(newChild);
                }
            }
        }
    }
}

