/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.rules;

import com.fortify.exceptions.FortifyException;
import com.fortify.io.FortifyCastorBase;
import com.fortify.io.XmlDocument;
import com.fortify.io.rule.Abstract;
import com.fortify.io.rule.CodeLibraries;
import com.fortify.io.rule.ControlflowStateStrings;
import com.fortify.io.rule.Coverage;
import com.fortify.io.rule.Description;
import com.fortify.io.rule.DescriptionTextElement;
import com.fortify.io.rule.Descriptions;
import com.fortify.io.rule.Explanation;
import com.fortify.io.rule.ExtendedCodeLibraries;
import com.fortify.io.rule.FunctionIdentifier;
import com.fortify.io.rule.LabelDefinitions;
import com.fortify.io.rule.Masks;
import com.fortify.io.rule.Recommendations;
import com.fortify.io.rule.References;
import com.fortify.io.rule.ResolutionLibraries;
import com.fortify.io.rule.ResolutionLibrary;
import com.fortify.io.rule.Rule;
import com.fortify.io.rule.RuleDefinitions;
import com.fortify.io.rule.RulePack;
import com.fortify.io.rule.Rules;
import com.fortify.io.rule.Script;
import com.fortify.io.rule.ScriptDefinition;
import com.fortify.io.rule.ScriptDefinitions;
import com.fortify.io.rule.ScriptDefinitionsChoice;
import com.fortify.io.rule.ScriptDefinitionsChoiceItem;
import com.fortify.io.rule.TaintFlagDeclarations;
import com.fortify.io.rule.TaintFlagDescriptions;
import com.fortify.io.rule.Tips;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.system.Version;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exolab.castor.types.Date;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RuleReader {
    static ILogger logger = MessageManager.getLogger(RuleReader.class);
    private static final String SUPPORTED_VERSION = "3.2";
    private static final String rulesPackage = Rule.class.getPackage().getName();
    private final String versionNumber;
    private final Reader in;
    private final String fileName;
    private final RulepackGate gate;
    private static final XMLContext cxt = new XMLContext();
    private boolean runCastorValidation = true;

    private static Class<? extends Rule> getClassForRule(String ruleName) {
        try {
            String className = rulesPackage + "." + ruleName;
            Class<?> cls = Class.forName(className);
            if (!Rule.class.isAssignableFrom(cls)) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Rule type " + ruleName + " maps to non-rule type " + cls);
                return null;
            }
            return cls;
        }
        catch (ClassNotFoundException cfne) {
            return null;
        }
    }

    public RuleReader(Reader in, String fileName, String versionNumber) {
        this(in, fileName, versionNumber, null);
    }

    public RuleReader(Reader in, String fileName, String versionNumber, RulepackGate gate) {
        this.in = in;
        this.versionNumber = versionNumber;
        this.fileName = fileName;
        this.gate = gate;
    }

    public FortifyCastorBase parse() throws FortifyException {
        XmlDocument xmlDoc = new XmlDocument(this.in, this.fileName);
        Document domDoc = xmlDoc.getDocument();
        if (domDoc == null) {
            throw new FortifyException(new Message(4, 212, this.fileName == null ? "unspecified" : this.fileName));
        }
        Element rootElement = domDoc.getDocumentElement();
        try {
            if ("RulePack".equals(rootElement.getTagName())) {
                return this.parseRulePack(rootElement);
            }
            if ("Rules".equals(rootElement.getTagName())) {
                return this.parseRules(rootElement);
            }
            throw new FortifyException(new Message(4, 212, this.fileName == null ? "unspecified" : this.fileName, rootElement.getTagName(), "RulePack, Rules"));
        }
        catch (MarshalException me) {
            this.handleMarshalException(me);
        }
        catch (ParseException pe) {
            throw new FortifyException(new Message(4, 212, this.fileName == null ? "unspecified" : this.fileName), (Throwable)pe);
        }
        catch (ValidationException ve) {
            this.handleValidationException(ve);
        }
        return null;
    }

    private void handleMarshalException(MarshalException me) throws FortifyException {
        Throwable cause = me.getCause();
        if (!(cause instanceof ValidationException)) {
            if (cause instanceof SAXException) {
                SAXException se = (SAXException)cause;
                Pattern linepat = Pattern.compile("Line : ([0-9]+)");
                Pattern colpat = Pattern.compile("Column : ([0-9]+)");
                String msg = se.getMessage();
                Matcher linem = linepat.matcher(msg);
                int line = -1;
                if (linem.find()) {
                    line = Integer.parseInt(linem.group(1));
                    msg = linem.replaceAll("");
                }
                int col = -1;
                Matcher colm = colpat.matcher(msg);
                if (colm.find()) {
                    col = Integer.parseInt(colm.group(1));
                    msg = colm.replaceAll("");
                }
                msg = msg.replaceAll("Parsing Error :", "").replaceAll("(?s)due to the following exception.*", "").trim();
                throw new FortifyException(new Message(4, 219, this.fileName == null ? "unspecified" : this.fileName, Integer.toString(line), Integer.toString(col), msg), (Throwable)me);
            }
            throw new FortifyException(new Message(4, 218, this.fileName == null ? "unspecified" : this.fileName, me.toString()), (Throwable)me);
        }
        this.handleValidationException((ValidationException)cause);
    }

    private void handleValidationException(ValidationException ve) throws FortifyException {
        if (!(ve.getCause() instanceof ValidationException)) {
            Pattern re;
            Matcher m;
            String msg = ve.getMessage();
            String loc = "unknown location";
            if (ve.getLocation() != null) {
                loc = ve.getLocation().toString().replaceAll("XPATH: ", "");
            }
            if ((m = (re = Pattern.compile("\\(whose xml name is '([A-Z0-9a-z]*)'\\) ")).matcher(msg)).find()) {
                String xmlname = m.group(1);
                String fieldname = "_" + xmlname.substring(0, 1).toLowerCase() + xmlname.substring(1);
                msg = m.replaceAll("").replaceAll(fieldname, xmlname);
            }
            throw new FortifyException(new Message(4, 220, this.fileName == null ? "unspecified" : this.fileName, loc, msg), (Throwable)ve);
        }
        this.handleValidationException((ValidationException)ve.getCause());
    }

    protected Rules parseRules(Element rulesElement) throws MarshalException, ValidationException, UnsupportedVersionException, SCATooOldForRulepackException {
        Rules rules = new Rules();
        String versionString = rulesElement.getAttribute("version");
        try {
            if (Version.compareVersions(versionString, SUPPORTED_VERSION) < 0) {
                throw new UnsupportedVersionException(versionString, this.fileName);
            }
        }
        catch (NullPointerException npe) {
            throw new UnsupportedVersionException(versionString, this.fileName);
        }
        String scaVersion = Version.getVersion(Version.Product.PROJECT);
        String requiredSCA = rulesElement.getAttribute("minimumSCA");
        if (requiredSCA != null && Version.compareVersions(scaVersion, requiredSCA, Version.Product.PROJECT) < 0) {
            throw new SCATooOldForRulepackException(scaVersion, requiredSCA, this.fileName);
        }
        rules.setVersion(versionString);
        NodeList childNodes = rulesElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            String tagName = childElement.getTagName();
            if ("RuleDefinitions".equals(tagName)) {
                rules.setRuleDefinitions(this.parseRuleDefinitions(childElement));
                continue;
            }
            if ("LabelDefinitions".equals(tagName)) {
                rules.setLabelDefinitions(this.parseLabelDefinitions(childElement));
                continue;
            }
            if ("FunctionIdentifier".equals(tagName)) continue;
            if ("Descriptions".equals(tagName)) {
                rules.setDescriptions(this.parseDescriptions(childElement));
                continue;
            }
            if ("TaintFlagDeclarations".equals(tagName)) {
                rules.setTaintFlagDeclarations(this.parseTaintFlagDeclarations(childElement));
                continue;
            }
            if ("TaintFlagDescriptions".equals(tagName)) {
                rules.setTaintFlagDescriptions(this.parseTaintFlagDescriptions(childElement));
                continue;
            }
            if ("Notes".equals(tagName)) {
                rules.setNotes(RuleReader.getElementContent(childElement));
                continue;
            }
            if ("ControlflowStateStrings".equals(tagName)) {
                rules.setControlflowStateStrings(this.parseStateStrings(childElement));
                continue;
            }
            if ("Script".equals(tagName)) {
                Script script = this.parseScript(childElement);
                if (script == null) continue;
                rules.addScript(script);
                continue;
            }
            if ("Coverage".equals(tagName)) {
                rules.setCoverage(this.parseCoverage(childElement));
                continue;
            }
            if (!"ScriptDefinitions".equals(tagName)) continue;
            rules.setScriptDefinitions(this.parseScriptDefinitions(childElement));
        }
        if (rules.getRuleDefinitions() == null) {
            throw new FortifyException(new Message(3, 223, this.fileName == null ? "unspecified" : this.fileName));
        }
        return rules;
    }

    protected RulePack parseRulePack(Element rpElement) throws MarshalException, ValidationException, ParseException, UnsupportedVersionException {
        Element childElement;
        Node childNode;
        int i;
        RulePack result = new RulePack();
        NodeList childNodes = rpElement.getChildNodes();
        if (this.gate != null) {
            for (i = 0; i < childNodes.getLength(); ++i) {
                String lang;
                childNode = childNodes.item(i);
                if (!(childNode instanceof Element) || !"Language".equals((childElement = (Element)childNode).getTagName()) || this.gate.shouldLoad((lang = RuleReader.getElementContent(childElement)).toLowerCase())) continue;
                throw new RulepackSkippedException("Rule language not required: " + lang);
            }
        }
        for (i = 0; i < childNodes.getLength(); ++i) {
            childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            childElement = (Element)childNode;
            String tagName = childElement.getTagName();
            if ("RulePackID".equals(tagName)) {
                result.setRulePackID(RuleReader.getElementContent(childElement));
                continue;
            }
            if ("SKU".equals(tagName)) {
                result.setSKU(RuleReader.getElementContent(childElement));
                continue;
            }
            if ("Name".equals(tagName)) {
                result.setName(RuleReader.getElementContent(childElement));
                continue;
            }
            if ("Activated".equals(tagName)) {
                result.setActivated("true".equalsIgnoreCase(RuleReader.getElementContent(childElement)));
                continue;
            }
            if ("Version".equals(tagName)) {
                result.setVersion(RuleReader.getElementContent(childElement));
                continue;
            }
            if ("Language".equals(tagName)) {
                result.setLanguage(RuleReader.getElementContent(childElement));
                continue;
            }
            if ("Description".equals(tagName)) {
                result.setDescription(RuleReader.getElementContent(childElement));
                continue;
            }
            if ("Rules".equals(tagName)) {
                result.setRules(this.parseRules(childElement));
                continue;
            }
            if ("Masks".equals(tagName)) {
                result.setMasks(this.parseMasks(childElement));
                continue;
            }
            if ("CodeLibraries".equals(tagName)) {
                result.setCodeLibraries(this.parseCodeLibraries(childElement));
                continue;
            }
            if ("ExtendedCodeLibraries".equals(tagName)) {
                result.setExtendedCodeLibraries(this.parseExtendedCodeLibraries(childElement));
                continue;
            }
            if ("ResolutionLibraries".equals(tagName)) {
                result.setResolutionLibraries(this.parseResolutionLibraries(childElement));
                continue;
            }
            if (!"Locale".equals(tagName)) continue;
            result.setLocale(RuleReader.getElementContent(childElement));
        }
        return result;
    }

    protected ScriptDefinitions parseScriptDefinitions(Element scriptDefElement) {
        ScriptDefinitions result = new ScriptDefinitions();
        ScriptDefinitionsChoice choice = new ScriptDefinitionsChoice();
        result.setScriptDefinitionsChoice(choice);
        NodeList childNodes = scriptDefElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            try {
                ScriptDefinition scriptDefinition;
                ScriptDefinitionsChoiceItem item;
                Element childElement = (Element)childNode;
                String tagName = childElement.getTagName();
                if ("Script".equals(tagName)) {
                    Script script = this.parseScript(childElement);
                    if (script == null) continue;
                    item = new ScriptDefinitionsChoiceItem();
                    item.setScript(script);
                    choice.addScriptDefinitionsChoiceItem(item);
                    continue;
                }
                if (!"ScriptDefinition".equals(tagName) || (scriptDefinition = this.parseScriptDefinition(childElement)) == null) continue;
                item = new ScriptDefinitionsChoiceItem();
                item.setScriptDefinition(scriptDefinition);
                choice.addScriptDefinitionsChoiceItem(item);
                continue;
            }
            catch (MarshalException me) {
                try {
                    this.handleMarshalException(me);
                }
                catch (FortifyException fe) {
                    logger.handleException(fe);
                }
                continue;
            }
            catch (ValidationException ve) {
                try {
                    this.handleValidationException(ve);
                    continue;
                }
                catch (FortifyException fe) {
                    logger.handleException(fe);
                }
            }
        }
        return result;
    }

    protected ResolutionLibraries parseResolutionLibraries(Element resLibElement) {
        ResolutionLibraries result = new ResolutionLibraries();
        NodeList childNodes = resLibElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            try {
                ResolutionLibrary lib;
                Element elt = (Element)childNode;
                String tagName = elt.getTagName();
                if (!"ResolutionLibrary".equals(tagName) || (lib = this.parseResolutionLibrary(elt)) == null) continue;
                result.addResolutionLibrary(lib);
                continue;
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
        return result;
    }

    private void handleException(Throwable t) {
        try {
            if (t instanceof MarshalException) {
                this.handleMarshalException((MarshalException)t);
            } else if (t instanceof ValidationException) {
                this.handleValidationException((ValidationException)t);
            } else {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception reading rule pack " + this.fileName, t);
            }
        }
        catch (FortifyException fe) {
            logger.handleException(fe);
        }
    }

    protected LabelDefinitions parseLabelDefinitions(Element ruleDefElement) {
        LabelDefinitions result = new LabelDefinitions();
        NodeList childNodes = ruleDefElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            String tagName = childElement.getTagName();
            if ("DeprecationRule".equals(tagName)) {
                this.parseAndAddRule(childElement, result);
                continue;
            }
            if ("SuppressionRule".equals(tagName)) {
                this.parseAndAddRule(childElement, result);
                continue;
            }
            if (!"CharacterizationRule".equals(tagName)) continue;
            this.parseAndAddRule(childElement, result);
        }
        return result;
    }

    protected RuleDefinitions parseRuleDefinitions(Element ruleDefElement) {
        RuleDefinitions result = new RuleDefinitions();
        NodeList childNodes = ruleDefElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            this.parseAndAddRule((Element)childNode, result);
        }
        return result;
    }

    private <T> void parseAndAddRule(Element childNode, T result) {
        Rule rule;
        try {
            rule = this.parseRule(childNode);
        }
        catch (MarshalException me) {
            try {
                this.handleMarshalException(me);
            }
            catch (FortifyException fe) {
                logger.handleException(fe);
            }
            return;
        }
        catch (ValidationException ve) {
            try {
                this.handleValidationException(ve);
            }
            catch (FortifyException fe) {
                logger.handleException(fe);
            }
            return;
        }
        if (rule != null) {
            try {
                Method addMethod = result.getClass().getMethod("add" + childNode.getNodeName(), rule.getClass());
                addMethod.invoke(result, rule);
            }
            catch (NoSuchMethodException nsme) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Couldn't add rule of type " + rule.getClass().getName(), (Throwable)nsme);
            }
            catch (IllegalAccessException iae) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Couldn't add rule of type " + rule.getClass().getName(), (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Couldn't add rule of type " + rule.getClass().getName(), (Throwable)ite);
            }
            catch (SecurityException se) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Couldn't add rule of type " + rule.getClass().getName(), (Throwable)se);
            }
            catch (IllegalArgumentException iae) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Couldn't add rule of type " + rule.getClass().getName(), (Throwable)iae);
            }
        }
    }

    protected Rule parseRule(Element ruleElement) throws MarshalException, ValidationException {
        String ruleType = ruleElement.getNodeName();
        String version = ruleElement.getAttribute("formatVersion");
        if (version == null) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "RuleReader encountered rule without formatVersion");
            return null;
        }
        if (Version.compareRulesFormatVersions(version, this.versionNumber) > 0) {
            return null;
        }
        Class<? extends Rule> ruleClass = RuleReader.getClassForRule(ruleType);
        if (ruleClass == null) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "RuleReader encountered unexpected rule element: " + ruleType);
            return null;
        }
        Unmarshaller um = this.createUnmarshallerI(ruleClass);
        return (Rule)um.unmarshal((Node)ruleElement);
    }

    protected static Date parseDate(Element dateElement) throws ParseException {
        String value = RuleReader.getElementContent(dateElement);
        return value == null ? null : Date.parseDate((String)value);
    }

    protected FunctionIdentifier parseFunctionIdentifier(Element eltFunctionIdentifier) throws MarshalException, ValidationException {
        return this.parseGeneric(eltFunctionIdentifier, FunctionIdentifier.class);
    }

    protected Descriptions parseDescriptions(Element descElt) throws MarshalException, ValidationException {
        Descriptions descriptions = new Descriptions();
        NodeList childNodes = descElt.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            References references;
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            String tagName = childElement.getTagName();
            if ("Description".equals(tagName)) {
                Description description = this.parseDescription(childElement);
                if (description == null) continue;
                descriptions.addDescription(description);
                continue;
            }
            if ("Abstract".equals(tagName)) {
                Abstract abst = this.parseDescriptionTextElement(childElement, Abstract.class);
                if (abst == null) continue;
                descriptions.addAbstract(abst);
                continue;
            }
            if ("Explanation".equals(tagName)) {
                Explanation explanation = this.parseDescriptionTextElement(childElement, Explanation.class);
                if (explanation == null) continue;
                descriptions.addExplanation(explanation);
                continue;
            }
            if ("Recommendations".equals(tagName)) {
                Recommendations recommendations = this.parseDescriptionTextElement(childElement, Recommendations.class);
                if (recommendations == null) continue;
                descriptions.addRecommendations(recommendations);
                continue;
            }
            if ("Tips".equals(tagName)) {
                Tips tips = this.parseTips(childElement);
                if (tips == null) continue;
                descriptions.addTips(tips);
                continue;
            }
            if (!"References".equals(tagName) || (references = this.parseReferences(childElement)) == null) continue;
            descriptions.addReferences(references);
        }
        return descriptions;
    }

    private References parseReferences(Element eltReferences) throws MarshalException, ValidationException {
        return this.parseGeneric(eltReferences, References.class);
    }

    private Tips parseTips(Element eltTips) throws MarshalException, ValidationException {
        return this.parseGeneric(eltTips, Tips.class);
    }

    private Description parseDescription(Element eltDescription) throws MarshalException, ValidationException {
        return this.parseGeneric(eltDescription, Description.class);
    }

    private <T extends DescriptionTextElement> T parseDescriptionTextElement(Element eltDTE, Class<T> eltClass) throws MarshalException, ValidationException {
        return (T)((DescriptionTextElement)this.parseGeneric(eltDTE, eltClass));
    }

    protected ControlflowStateStrings parseStateStrings(Element eltDescriptions) throws MarshalException, ValidationException {
        return this.parseGeneric(eltDescriptions, ControlflowStateStrings.class);
    }

    protected Script parseScript(Element eltScript) throws MarshalException, ValidationException {
        return this.parseGeneric(eltScript, Script.class);
    }

    protected ScriptDefinition parseScriptDefinition(Element eltScriptDefinition) throws MarshalException, ValidationException {
        return this.parseGeneric(eltScriptDefinition, ScriptDefinition.class);
    }

    protected TaintFlagDeclarations parseTaintFlagDeclarations(Element eltTaintFlagDeclarations) throws MarshalException, ValidationException {
        return this.parseGeneric(eltTaintFlagDeclarations, TaintFlagDeclarations.class);
    }

    private TaintFlagDescriptions parseTaintFlagDescriptions(Element eltTaintFlagDescriptions) throws ValidationException, MarshalException {
        return this.parseGeneric(eltTaintFlagDescriptions, TaintFlagDescriptions.class);
    }

    protected Masks parseMasks(Element eltMasks) throws MarshalException, ValidationException {
        return this.parseGeneric(eltMasks, Masks.class);
    }

    protected CodeLibraries parseCodeLibraries(Element eltCodeLibs) throws MarshalException, ValidationException {
        return this.parseGeneric(eltCodeLibs, CodeLibraries.class);
    }

    protected ExtendedCodeLibraries parseExtendedCodeLibraries(Element eltCodeLibs) throws MarshalException, ValidationException {
        return this.parseGeneric(eltCodeLibs, ExtendedCodeLibraries.class);
    }

    protected ResolutionLibrary parseResolutionLibrary(Element eltResLib) throws MarshalException, ValidationException {
        return this.parseGeneric(eltResLib, ResolutionLibrary.class);
    }

    private Coverage parseCoverage(Element eltCoverage) throws MarshalException, ValidationException {
        return this.parseGeneric(eltCoverage, Coverage.class);
    }

    protected static String getElementContent(Element elt) {
        Node content = elt.getFirstChild();
        return content == null ? null : content.getNodeValue();
    }

    protected <T> T parseGeneric(Element element, Class<T> type) throws MarshalException, ValidationException {
        String version = element.getAttribute("formatVersion");
        if (version != null && Version.compareRulesFormatVersions(version, this.versionNumber) > 0) {
            return null;
        }
        Unmarshaller um = this.createUnmarshallerI(type);
        return (T)um.unmarshal((Node)element);
    }

    protected Unmarshaller createUnmarshallerI(Class<?> type) {
        Unmarshaller result = RuleReader.createUnmarshaller(type);
        result.setValidation(this.runCastorValidation);
        return result;
    }

    public static Unmarshaller createUnmarshaller(Class<?> type) {
        Unmarshaller result = cxt.createUnmarshaller();
        result.setClass(type);
        result.setWhitespacePreserve(true);
        return result;
    }

    public static Marshaller createMarshaller() {
        return cxt.createMarshaller();
    }

    public void setRunCastorValidation(boolean runValidation) {
        this.runCastorValidation = runValidation;
    }

    static {
        cxt.setProperty("org.exolab.castor.xml.lenient.sequence.order", true);
        cxt.setProperty("org.exolab.castor.regexp", (Object)"org.exolab.castor.util.JakartaOroEvaluator");
        cxt.setProperty("org.exolab.castor.xml.strictelements", true);
        try {
            cxt.addPackage("com.fortify.io.rule");
            cxt.addPackage("com.fortify.io.rule.types");
            cxt.addPackage("com.fortify.io.mask");
            cxt.addPackage("com.fortify.io.dynamictext");
        }
        catch (ResolverException e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception initializing rule reader", (Throwable)e);
        }
    }

    public static class RulepackSkippedException
    extends FortifyException {
        public RulepackSkippedException(String msg) {
            super(new Message(1, "Skipping rulepack: " + msg));
        }
    }

    public static class SCATooOldForRulepackException
    extends FortifyException {
        public SCATooOldForRulepackException(String scaVersion, String requiredVersion, String filename) {
            super(new Message(4, 246, filename == null ? "unspecified" : filename, requiredVersion, scaVersion));
        }
    }

    public static class UnsupportedVersionException
    extends FortifyException {
        private final String versionString;

        public UnsupportedVersionException(String versionString, String fileName) {
            super(new Message(3, 217, fileName == null ? "unspecified" : fileName, versionString));
            this.versionString = versionString;
        }

        public String getVersionString() {
            return this.versionString;
        }
    }

    public static interface RulepackGate {
        public boolean shouldLoad(String var1);
    }
}

