/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.rules;

import com.fortify.configuration.SCAConfigurationUtil;
import com.fortify.exceptions.FortifyException;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Localization;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.rules.SCARulePack;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.FileUtil;
import com.fortify.util.RulepackUtil;
import com.fortify.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class RulepackManager {
    static ILogger logger = MessageManager.getLogger(RulepackManager.class);
    private static final String CORE_RULES = "config" + File.separator + "rules";
    private static final String CUSTOM_RULES = "config" + File.separator + "customrules";
    public static final String RP_UPDATE_PROPERTIES = "rp.update.properties";
    public static final String PK_RPLAST_UPDATE = "lastUpdated";
    private static final String RP_DEFAULT_UPDATE = Localization.getLocalString(260, new Object[0]);
    public static final DateFormat LAST_UPDATE_DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
    private static Properties scaProps = null;
    static final Pattern pattern = Pattern.compile("^([\\p{L}\\p{M}\\p{N}\\p{Pd}\\p{Pc}\\.])+\\.(xml|bin|rpr)$", 128);

    public static String getSCAInstallCoreDirectory() {
        File scaExecutable = new File(SCAConfigurationUtil.getSCAPath());
        if (!scaExecutable.exists()) {
            return null;
        }
        if (SCAConfigurationUtil.isDevInspect(scaExecutable.getAbsolutePath())) {
            File libExeDir = scaExecutable.getParentFile();
            File libDir = libExeDir == null ? null : libExeDir.getParentFile();
            String coreDir = libDir == null ? null : libDir.getParent();
            return coreDir == null ? File.separator + "Core" : coreDir;
        }
        File binDir = scaExecutable.getParentFile();
        String installDir = binDir.getParent();
        return installDir + File.separator + "Core";
    }

    public static String getCoreRulesDirectory() {
        String scaProperty = SCAConfigurationUtil.getSCAProperty(SCAConfigurationUtil.CORE_RULES);
        if (scaProperty != null) {
            return scaProperty;
        }
        String scaInstallCoreDir = RulepackManager.getSCAInstallCoreDirectory();
        if (scaInstallCoreDir != null) {
            String rulesDirProperty = RulepackManager.getSCAProperties().getProperty(SCAConfigurationUtil.CORE_RULES);
            if (rulesDirProperty != null) {
                return rulesDirProperty;
            }
            return scaInstallCoreDir + File.separator + CORE_RULES;
        }
        return SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_CORE) + File.separator + CORE_RULES;
    }

    private static Properties getSCAProperties() {
        if (scaProps == null) {
            RulepackManager.loadSCAProperties();
        }
        return scaProps;
    }

    public static void reload() {
        scaProps = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadSCAProperties() {
        scaProps = new Properties();
        String scaInstallCoreDir = RulepackManager.getSCAInstallCoreDirectory();
        if (scaInstallCoreDir != null) {
            File fortifyProperties = new File(new File(scaInstallCoreDir, "config"), "fortify.properties");
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(fortifyProperties);
                scaProps.load(fin);
            }
            catch (FileNotFoundException e) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "fortify.properties of selected sourceanalyzer could not be found" + e.getMessage());
                FileUtil.close(fin);
            }
            catch (IOException e2) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "fortify.properties of selected sourceanalyzer could not be loaded" + e2.getMessage());
                {
                    catch (Throwable throwable) {
                        FileUtil.close(fin);
                        throw throwable;
                    }
                }
                FileUtil.close(fin);
            }
            FileUtil.close(fin);
        }
    }

    public static String getCustomRulesDirectory() {
        String scaProperty = SCAConfigurationUtil.getSCAProperty(SCAConfigurationUtil.CUSTOM_RULES);
        if (scaProperty != null) {
            return scaProperty;
        }
        String scaInstallCoreDir = RulepackManager.getSCAInstallCoreDirectory();
        if (scaInstallCoreDir != null) {
            String rulesDirProperty = RulepackManager.getSCAProperties().getProperty(SCAConfigurationUtil.CUSTOM_RULES);
            if (rulesDirProperty != null) {
                return rulesDirProperty;
            }
            return scaInstallCoreDir + File.separator + CUSTOM_RULES;
        }
        return SystemUtil.getProperty(CommonPropertyKeys.PK_FORTIFY_CORE) + File.separator + CUSTOM_RULES;
    }

    public static SCARulePack[] getInstalledRulePacks() throws IOException {
        File rulePackDir = new File(RulepackManager.getCoreRulesDirectory());
        List<SCARulePack> result = RulepackManager.loadRulepacks(rulePackDir, true);
        SCARulePack[] scaRulePacks = result.toArray(new SCARulePack[result.size()]);
        Arrays.sort(scaRulePacks, new RulePackComparator());
        return scaRulePacks;
    }

    public static SCARulePack[] getCustomRulepacks() throws IOException {
        File rulePackDir = new File(RulepackManager.getCustomRulesDirectory());
        List<SCARulePack> result = RulepackManager.loadRulepacks(rulePackDir, true);
        SCARulePack[] scaRulePacks = result.toArray(new SCARulePack[result.size()]);
        Arrays.sort(scaRulePacks, new RulePackComparator());
        return scaRulePacks;
    }

    public static SCARulePack[] getAllRulepacks() throws IOException {
        File rulePackDir = new File(RulepackManager.getCustomRulesDirectory());
        List<SCARulePack> result = RulepackManager.loadRulepacks(rulePackDir, true);
        rulePackDir = new File(RulepackManager.getCoreRulesDirectory());
        result.addAll(RulepackManager.loadRulepacks(rulePackDir, true));
        SCARulePack[] scaRulePacks = result.toArray(new SCARulePack[result.size()]);
        Arrays.sort(scaRulePacks, new RulePackComparator());
        return scaRulePacks;
    }

    public static List<SCARulePack> loadRulepacks(File rulePackDir, boolean loadXMLWithoutHeaders) throws IOException {
        File[] contents = RulepackUtil.getRulepacks(rulePackDir);
        if (contents == null) {
            throw new IOException("Unable to read directory '" + rulePackDir.getPath() + "'");
        }
        ArrayList<SCARulePack> result = new ArrayList<SCARulePack>();
        for (File content : contents) {
            SCARulePack rp;
            if (!content.isFile() || (rp = SCARulePack.loadRulepack(content, loadXMLWithoutHeaders)) == null) continue;
            result.add(rp);
        }
        return result;
    }

    public static String deleteInstalledRulePack(String fortifyHomeDir, String id) throws IOException {
        File rulePackDir = new File(RulepackManager.getCoreRulesDirectory());
        File[] contents = RulepackUtil.getRulepacks(rulePackDir);
        if (contents == null) {
            throw new IOException("Unable to read directory '" + rulePackDir.getPath() + "'");
        }
        String name = null;
        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Trying to delete rulepack: " + id);
        for (File content : contents) {
            SCARulePack rp;
            if (!content.isFile() || !(rp = SCARulePack.loadRulepack(content, false)).getRulePackID().equals(id)) continue;
            name = rp.getName();
            boolean s = content.delete();
            if (s) {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "File deleted:" + content.getAbsolutePath());
            } else {
                logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "File not deleted:" + content.getAbsolutePath());
            }
            return name;
        }
        return name;
    }

    public static void importRulepacks(String[] paths) throws IOException {
        try {
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                File rulepackToImport = new File(path);
                File newRulepack = new File(RulepackManager.getCustomRulesDirectory(), rulepackToImport.getName());
                FileUtil.copy(rulepackToImport, newRulepack);
            }
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error writing to custom rules directory", (Throwable)e);
            throw e;
        }
    }

    public static void doLocalUpdate(String[] paths) throws IOException {
        String msg;
        String rulesFolder = RulepackManager.getCoreRulesDirectory();
        File rulesDir = new File(rulesFolder);
        if (!rulesDir.exists() && !FileUtil.mkdirs(rulesDir)) {
            throw new FortifyException(new Message(4, 6235, rulesFolder));
        }
        if (!rulesDir.canRead()) {
            throw new FortifyException(new Message(4, 6234, rulesFolder));
        }
        if (!rulesDir.canWrite()) {
            throw new FortifyException(new Message(4, 6235, rulesFolder));
        }
        File[] files = RulepackUtil.getRulepacks(rulesDir);
        if (files == null) {
            throw new FortifyException(new Message(4, 6236, new Object[0]));
        }
        File coreConfigDir = new File(rulesFolder).getParentFile();
        if (coreConfigDir == null || coreConfigDir.getParentFile() == null) {
            throw new FortifyException(new Message(4, 6234, coreConfigDir));
        }
        File externalMetadataDir = new File(coreConfigDir, "ExternalMetadata");
        if (!externalMetadataDir.exists() && !FileUtil.mkdirs(externalMetadataDir)) {
            throw new FortifyException(new Message(4, 6235, "ExternalMetadata"));
        }
        if (files.length > 0) {
            msg = new Message(1, 6216, rulesDir.getPath()).getLocalizedMessage();
            logger.log(ILoggerMin.Level.INFO, ILoggerMin.Marker.LOG, msg);
        }
        msg = null;
        for (File file : files) {
            msg = file.delete() ? file.getAbsolutePath() : new Message(1, 6216, file).getLocalizedMessage();
            logger.log(ILoggerMin.Level.INFO, ILoggerMin.Marker.LOG, msg);
        }
        logger.log(ILoggerMin.Level.INFO, ILoggerMin.Marker.LOG, msg);
        try {
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                File rulepackToImport = new File(path);
                if (!FileUtil.isExistingFile(rulepackToImport) || !FileUtil.isZipFile(rulepackToImport)) continue;
                FileUtil.extractRulepacksZip(rulepackToImport, coreConfigDir.getParentFile().getAbsolutePath(), pattern, FileUtil.FilesToInclude.RulesAndMetadata);
            }
        }
        catch (IOException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error extracting zipped rulepacks into the local rules directory", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static String getLastUpdateTimestamp() {
        String string;
        String rulesDir = RulepackManager.getCoreRulesDirectory();
        File updateFile = new File(rulesDir, RP_UPDATE_PROPERTIES);
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(updateFile);
            Properties props = new Properties();
            props.load(ins);
            string = props.getProperty(PK_RPLAST_UPDATE, RP_DEFAULT_UPDATE);
        }
        catch (FileNotFoundException e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Error loading update.properties", (Throwable)e);
            FileUtil.close(ins);
        }
        catch (IOException e2) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Error loading update.properties", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    FileUtil.close(ins);
                    throw throwable;
                }
            }
            FileUtil.close(ins);
        }
        FileUtil.close(ins);
        return string;
        return RP_DEFAULT_UPDATE;
    }

    public static synchronized Date parseLastUpdate(String lastUpdate) throws ParseException {
        return LAST_UPDATE_DATE_FORMAT.parse(lastUpdate);
    }

    public static synchronized String formatLastUpdate(Date lastUpdate) {
        return LAST_UPDATE_DATE_FORMAT.format(lastUpdate);
    }

    public static Date getLastUpdateTimestampDate() {
        Date startDate = null;
        String lastUpdate = RulepackManager.getLastUpdateTimestamp();
        try {
            startDate = RulepackManager.parseLastUpdate(lastUpdate);
        }
        catch (ParseException e) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Unable to parse date \"" + lastUpdate + "\" of last rulepack update: ");
            logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "Exception parsing date \"" + lastUpdate + "\" of last rulepack update: ", (Throwable)e);
            return new Date(0L);
        }
        return startDate;
    }

    public static File getLibExeBasedOnSCAPath() {
        File libExeDirectory;
        String coreDirectory = RulepackManager.getSCAInstallCoreDirectory();
        if (coreDirectory != null && (libExeDirectory = new File(new File(coreDirectory, "lib"), "exe")) != null && libExeDirectory.exists()) {
            return libExeDirectory;
        }
        return null;
    }

    static {
        LAST_UPDATE_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static class RulePackComparator
    implements Comparator<SCARulePack> {
        @Override
        public int compare(SCARulePack o1, SCARulePack o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

