/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.rules;

import com.fortify.exceptions.FortifyException;
import com.fortify.io.FortifyCastorBase;
import com.fortify.io.rule.RulePack;
import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.report.EngineDataRulepackInfo;
import com.fortify.rules.RuleReader;
import com.fortify.system.Version;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.CryptoUtil;
import com.fortify.util.FileUtil;
import com.fortify.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class SCARulePack
implements EngineDataRulepackInfo {
    static ILogger logger = MessageManager.getLogger(SCARulePack.class);
    private final String name;
    private final String sku;
    private final String description;
    private final String version;
    private final String rulePackID;
    private final String path;
    private final String revision;
    private final String locale;
    private final boolean disabled;
    private final String language;
    private final String context;
    public static HashMap<String, String> disabledRulepackMap = null;

    public SCARulePack(String name, String sku, String description, String version, String rulePackID, String path, boolean disabled, String revision, String locale, String language, String context) {
        this.name = name;
        this.sku = sku;
        this.description = description;
        this.version = version;
        this.rulePackID = rulePackID;
        this.path = path;
        this.disabled = disabled;
        this.revision = revision;
        this.locale = locale;
        this.language = language;
        this.context = context;
    }

    public SCARulePack(String name, String sku, String description, String version, String rulePackID, String path, boolean disabled, String revision, String locale, String language) {
        this(name, sku, description, version, rulePackID, path, disabled, revision, locale, language, null);
    }

    public SCARulePack(File content) {
        this.name = content.getName();
        this.sku = content.getName();
        this.rulePackID = content.getName();
        this.description = content.getName();
        this.version = content.getName();
        this.path = content.getAbsolutePath();
        this.revision = content.getName();
        this.disabled = false;
        this.locale = SystemUtil.getFortifyLocale().getDisplayLanguage();
        this.language = content.getName();
        this.context = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.rulePackID;
    }

    @Override
    public String getSku() {
        return this.sku;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getRulePackID() {
        return this.rulePackID;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getContext() {
        return this.context;
    }

    public String toString() {
        return this.name;
    }

    public static boolean isDisabledRuleFile(String filename) {
        if (disabledRulepackMap == null) {
            disabledRulepackMap = new HashMap();
            String disableRegex = SystemUtil.getProperty(CommonPropertyKeys.PK_RULES_SKIP);
            if (disableRegex != null) {
                StringTokenizer st = new StringTokenizer(disableRegex, ";");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().toLowerCase();
                    disabledRulepackMap.put(token, token);
                }
            }
        }
        return disabledRulepackMap.get(filename.toLowerCase()) != null;
    }

    public static SCARulePack loadRulepack(File content, boolean loadXMLWithoutHeaders) throws IOException {
        return SCARulePack.loadRulepack(content, loadXMLWithoutHeaders, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SCARulePack loadRulepack(File content, boolean loadXMLWithoutHeaders, boolean doNotReplaceRPName, boolean doNotLogExceptions) throws IOException {
        FileReader fr;
        SCARulePack rp = null;
        boolean disabled = SCARulePack.isDisabledRuleFile(content.getName());
        if (content.getName().toLowerCase().endsWith(".bin")) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(content);
                rp = SCARulePack.loadRulepack(content.getPath(), disabled, fis);
                return rp;
            }
            catch (IOException e) {
                if (doNotLogExceptions) return rp;
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 212, (Throwable)e, content.getPath());
                return rp;
            }
            finally {
                if (FileUtil.close(fis) != null) {
                    logger.log(ILoggerMin.Level.TRACE, ILoggerMin.Marker.LOG_VERBOSE, "getInstalledRulePacks: Error closing input stream");
                }
            }
        } else {
            if (!content.getName().toLowerCase().endsWith(".xml")) return rp;
            fr = null;
            fr = new FileReader(content);
            RuleReader reader = new RuleReader(fr, content.getName(), Version.getRulesFormatVersion());
            FortifyCastorBase castorBase = reader.parse();
            if (castorBase instanceof RulePack) {
                RulePack xmlRp = (RulePack)castorBase;
                rp = new SCARulePack("".equals(xmlRp.getName()) && !doNotReplaceRPName ? content.getName() : xmlRp.getName(), xmlRp.getSKU(), xmlRp.getDescription(), xmlRp.getVersion(), xmlRp.getRulePackID(), content.getPath(), disabled, xmlRp.getMasks() != null ? xmlRp.getMasks().getRevision() : null, xmlRp.getLocale(), xmlRp.getLanguage(), xmlRp.getContext());
            }
            if (fr == null) return rp;
            try {
                fr.close();
                return rp;
            }
            catch (IOException ex) {
                if (doNotLogExceptions) return rp;
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 212, (Throwable)ex, content.getPath());
            }
        }
        return rp;
        catch (FortifyException ex) {
            try {
                if (!doNotLogExceptions) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 212, (Throwable)ex, content.getPath());
                }
                if (loadXMLWithoutHeaders) {
                    rp = new SCARulePack(content);
                }
                if (fr == null) return rp;
            }
            catch (Throwable throwable) {
                if (fr == null) throw throwable;
                try {
                    fr.close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    if (doNotLogExceptions) throw throwable;
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 212, (Throwable)ex2, content.getPath());
                }
                throw throwable;
            }
            try {
                fr.close();
                return rp;
            }
            catch (IOException ex3) {
                if (doNotLogExceptions) return rp;
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARNING, 212, (Throwable)ex3, content.getPath());
            }
            return rp;
        }
    }

    public static SCARulePack loadRulepack(InputStream fis) throws IOException {
        return SCARulePack.loadRulepack(null, false, fis);
    }

    private static SCARulePack loadRulepack(String path, boolean disabled, InputStream fis) throws IOException {
        Properties rpProps = CryptoUtil.readHeaders((InputStream)fis);
        Date expDate = null;
        if (rpProps.containsKey("Expiration")) {
            try {
                expDate = new org.exolab.castor.types.Date(rpProps.getProperty("Expiration")).toDate();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new SCARulePack(rpProps.getProperty("Name"), rpProps.getProperty("SKU"), rpProps.getProperty("Description"), rpProps.getProperty("Version"), rpProps.getProperty("RulePackID"), path, disabled, rpProps.getProperty("Revision"), rpProps.getProperty("Locale"), rpProps.getProperty("Language"), rpProps.getProperty("Context"));
    }
}

