/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.system;

import java.io.IOException;

public class BrowserControl {
    private static final String WIN_ID = "Windows";
    private static final String[] UNIX_BROWSERS = new String[]{"firefox", "mozilla", "opera", "netscape", "open"};

    public static Process displayURL(String url) throws IOException {
        return BrowserControl.doDisplayURL(url, 1);
    }

    public static Process displayURLV2(String url) throws IOException {
        return BrowserControl.doDisplayURL(url, 2);
    }

    private static Process doDisplayURL(String url, int version) throws IOException {
        Process process = null;
        boolean windows = BrowserControl.isWindowsPlatform();
        String cmd = null;
        if (windows) {
            cmd = version == 2 ? "rundll32 url.dll,FileProtocolHandler " + url : "rundll32 url.dll,FileProtocolHandler \"" + url + "\"";
            process = Runtime.getRuntime().exec(cmd);
        } else {
            for (int i = 0; i < UNIX_BROWSERS.length; ++i) {
                cmd = UNIX_BROWSERS[i] + " " + url;
                try {
                    process = Runtime.getRuntime().exec(cmd);
                    int exitCode = process.waitFor();
                    if (exitCode != 0) continue;
                    break;
                }
                catch (InterruptedException x) {
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return process;
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static void main(String[] args) {
        try {
            BrowserControl.displayURL("http://www.javaworld.com");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

