/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.system;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Message;
import com.fortify.messaging.MessageManager;
import com.fortify.system.InputEater;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import com.fortify.util.WindowsArgProtector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;

public class Exec {
    static ILogger logger = MessageManager.getLogger(Exec.class);
    private InputEater err;
    private InputEater in;
    protected String cmd = null;
    private String[] args = null;
    private String programName = null;
    private boolean protectArgs = false;
    private File workingDirectory = null;
    private int exitCode;
    private String outputFile = null;
    private Process process = null;
    private boolean beingDestroyed = false;
    private String[] envp = null;
    private PrintStream stdoutDump;
    private PrintStream stderrDump;
    private boolean stdoutKeep = false;
    private boolean stderrKeep = false;
    private InputStream stdinPipeStream = null;
    private long timeout = 0L;

    public Exec(String cmd) {
        this.cmd = cmd;
        this.programName = cmd;
    }

    public Exec(String cmd, File workingDirectory) {
        this.cmd = cmd;
        this.programName = cmd;
        this.workingDirectory = workingDirectory;
    }

    public Exec(String[] args) {
        this(args, false);
    }

    public Exec(String[] args, boolean protectArgs) {
        this(args, null, protectArgs);
    }

    public Exec(String[] args, long timeout, boolean protectArgs) {
        this(args, null, timeout, protectArgs);
    }

    public Exec(String[] args, File workingDirectory) {
        this(args, workingDirectory, false);
    }

    public Exec(String[] args, File workingDirectory, boolean protectArgs) {
        this.args = args;
        this.programName = args[0];
        this.workingDirectory = workingDirectory;
        this.protectArgs = protectArgs;
    }

    public Exec(String[] args, File workingDirectory, long timeout, boolean protectArgs) {
        this(args, workingDirectory, protectArgs);
        this.timeout = timeout;
    }

    public String getCommandString() {
        if (this.cmd != null) {
            return this.cmd;
        }
        String[] cmdArgs = this.protectArgs ? Exec.protectCommandLine(this.args) : this.args;
        return StringUtil.join(cmdArgs);
    }

    public void runIt() throws IOException {
        if (this.cmd != null) {
            this.checkCommandLength(new String[]{this.cmd});
            this.process = this.workingDirectory == null ? Runtime.getRuntime().exec(this.cmd, this.envp) : Runtime.getRuntime().exec(this.cmd, this.envp, this.workingDirectory);
        } else {
            String[] passArgs = this.args;
            if (this.protectArgs) {
                passArgs = Exec.protectCommandLine(passArgs);
            }
            this.checkCommandLength(passArgs);
            this.process = this.workingDirectory == null ? Runtime.getRuntime().exec(passArgs, this.envp) : Runtime.getRuntime().exec(passArgs, this.envp, this.workingDirectory);
        }
        InputStream stdout = this.process.getInputStream();
        InputStream stderr = this.process.getErrorStream();
        this.err = this.stderrDump != null ? new InputEater(stderr, this.stderrDump, this.stderrKeep) : new InputEater(stderr);
        this.err.start();
        this.in = this.outputFile != null ? new InputEater(stdout, this.outputFile) : (this.stdoutDump != null ? new InputEater(stdout, this.stdoutDump, this.stdoutKeep) : new InputEater(stdout));
        this.in.start();
        if (this.stdinPipeStream != null) {
            new Thread(new StdinPipeRunner(this.stdinPipeStream, this.process.getOutputStream())).start();
        } else {
            this.process.getOutputStream().close();
        }
        try {
            this.exitCode = this.process.waitFor();
            this.err.join(this.timeout);
            this.in.join(this.timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void checkCommandLength(String[] command) {
        if (SystemUtil.isWindows()) {
            int len = 0;
            for (int i = 0; i < command.length; ++i) {
                len += command[i].length();
                if (i + 1 >= command.length) continue;
                ++len;
            }
            if (len > Short.MAX_VALUE) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exec: command line length (" + len + ") too long.  CreateProcess may fail");
            }
        }
    }

    public String getStdout() {
        return this.in.getOutput();
    }

    public String getStderr() {
        return this.err.getOutput();
    }

    public void pipeStdin(InputStream input) {
        this.stdinPipeStream = input;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void destroy() {
        this.beingDestroyed = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public boolean isBeingDestroyed() {
        return this.beingDestroyed;
    }

    public void setDumpToStdOut(boolean dumpToStdOut) {
        if (dumpToStdOut) {
            this.stderrDump = System.out;
            this.stdoutDump = System.out;
        } else {
            this.stderrDump = null;
            this.stdoutDump = null;
        }
    }

    public void setStdOutStream(PrintStream out, boolean keepInBuffer) {
        this.stdoutDump = out;
        this.stdoutKeep = keepInBuffer;
    }

    public void setStdErrStream(PrintStream err, boolean keepInBuffer) {
        this.stderrDump = err;
        this.stderrKeep = keepInBuffer;
    }

    public static Process exec(String[] cmdarray) throws IOException {
        return Runtime.getRuntime().exec(Exec.protectCommandLine(cmdarray));
    }

    public static Process exec(String[] cmdarray, String[] envp) throws IOException {
        return Runtime.getRuntime().exec(Exec.protectCommandLine(cmdarray), envp);
    }

    public static Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        return Runtime.getRuntime().exec(Exec.protectCommandLine(cmdarray), envp, dir);
    }

    public static String[] protectCommandLine(String[] cmd) {
        if (cmd == null) {
            throw new NullPointerException("cmd");
        }
        if (cmd.length == 0) {
            throw new IllegalArgumentException("cmd.length == 0");
        }
        if (SystemUtil.isWindows()) {
            String[] protectedCmd = new String[cmd.length];
            protectedCmd[0] = cmd[0];
            for (int i = 1; i < cmd.length; ++i) {
                protectedCmd[i] = WindowsArgProtector.quoteMaybe(cmd[i]);
            }
            return protectedCmd;
        }
        return cmd;
    }

    public void setEnvp(String[] newEnvp) {
        this.envp = newEnvp;
    }

    public void setEnv(Map newEnv) {
        if (newEnv == null) {
            this.envp = null;
            return;
        }
        String[] array = new String[newEnv.size()];
        int arrayPos = 0;
        for (Map.Entry e : newEnv.entrySet()) {
            array[arrayPos++] = e.getKey() + "=" + e.getValue();
        }
        this.envp = array;
    }

    public static class StdinPipeRunner
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public StdinPipeRunner(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block13: {
                int read;
                BufferedInputStream bin = new BufferedInputStream(this.in);
                byte[] buf = new byte[256];
                while ((read = bin.read(buf)) != -1 && !Thread.interrupted()) {
                    try {
                        this.out.write(buf, 0, read);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    logger.handleException(new Message(3, 1, ioe.toString()), ioe);
                }
                break block13;
                catch (IOException ioe) {
                    try {
                        logger.handleException(new Message(3, 1, ioe.toString()), ioe);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.out.close();
                        }
                        catch (IOException ioe2) {
                            logger.handleException(new Message(3, 1, ioe2.toString()), ioe2);
                        }
                        throw throwable;
                    }
                    try {
                        this.out.close();
                    }
                    catch (IOException ioe3) {
                        logger.handleException(new Message(3, 1, ioe3.toString()), ioe3);
                    }
                }
            }
        }
    }
}

