/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.system;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputEater
implements Runnable {
    static ILogger logger = MessageManager.getLogger(InputEater.class);
    private static final int BUFFER_SIZE = 4096;
    private static int instanceCount = 0;
    private final Thread thread;
    private final InputStream in;
    private boolean useInternalBuffer = true;
    private final ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
    private OutputStream outputStream;
    private boolean outputStreamNeedsClose = false;
    private Throwable caughtException;

    public InputEater(InputStream in) {
        this.in = new BufferedInputStream(in, 4096);
        this.thread = new Thread((Runnable)this, "InputEater-" + instanceCount++);
        this.thread.setDaemon(true);
        this.thread.setPriority(10);
    }

    public InputEater(InputStream in, OutputStream out, boolean buffer) {
        this(in);
        this.setOutputStream(out);
        this.enableInternalBuffer(buffer);
    }

    public InputEater(InputStream in, String outputFile) throws IOException {
        this(in);
        this.setOutputFile(outputFile);
        this.enableInternalBuffer(false);
    }

    public void setOutputFile(String outputFileName) throws IOException {
        this.outputStream = new FileOutputStream(outputFileName);
        this.outputStreamNeedsClose = true;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.outputStreamNeedsClose = false;
    }

    public void enableInternalBuffer(boolean value) {
        this.useInternalBuffer = value;
    }

    public void start() {
        this.thread.start();
    }

    public void join() throws InterruptedException {
        this.thread.join();
    }

    public void join(long millis) throws InterruptedException {
        this.thread.join(millis);
    }

    @Override
    public void run() {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = this.in.read(buf)) != -1) {
                if (this.useInternalBuffer) {
                    this.outputBuffer.write(buf, 0, len);
                }
                if (this.outputStream == null) continue;
                this.outputStream.write(buf, 0, len);
            }
        }
        catch (Throwable e) {
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Unexpected exception reading from stream", e);
            this.caughtException = e;
        }
        finally {
            FileUtil.close(this.in);
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                }
                catch (IOException e) {
                    logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Unexpected exception writing to stream", (Throwable)e);
                }
                if (this.outputStreamNeedsClose) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Unexpected exception writing to stream", (Throwable)e);
                    }
                }
            }
        }
    }

    public String getOutput() {
        if (!this.useInternalBuffer) {
            throw new IllegalStateException("Output buffering disabled");
        }
        return this.outputBuffer.toString();
    }

    public Throwable getException() {
        return this.caughtException;
    }
}

