/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.system;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import com.fortify.util.StringUtil;
import com.fortify.util.Triple;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    static ILogger logger = MessageManager.getLogger(Version.class);
    private static final String FVDL_VERSION = "1.12";
    private static final String AUDITREPORT_VERSION = "4.4";
    private static final String ATTACHMENTS_VERSION = "1.1";
    private static final String FPR_VERSION = "1.3";
    public static final String FILTERTEMPLATE_VERSION = "1.2";
    public static final String EXTERNAL_METADATA_VERSION = "1.1";
    private static String DEFAULT_VERSION = "0.0.0.0000";
    private static String releaseDate = "01/01/2076";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d{1,2}\\.){1,3}\\d{1,4}");
    private static ConcurrentMap<Triple<Product, String, String>, Integer> cvCache = new ConcurrentHashMap<Triple<Product, String, String>, Integer>();

    public static String getVersion(Product product) {
        return product.getVersion();
    }

    public static String getVersion() {
        return Version.getVersion(Product.PROJECT);
    }

    public static String getMajorMinorVersion(Product product) {
        String version = Version.getVersion(product);
        return Version.getMajorMinorVersion(version);
    }

    public static String getMajorMinorVersion(String version) {
        String majorminor;
        if (StringUtil.isEmpty(version)) {
            return version;
        }
        String[] parts = version.split("\\.");
        if (parts.length >= 2) {
            majorminor = parts[1].length() == 1 ? parts[0] + "." + parts[1] : parts[0] + "." + parts[1].charAt(0);
        } else {
            majorminor = version;
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Version number in unexpected format: " + version);
        }
        return majorminor;
    }

    public static String getVersionString(Product product) {
        return Version.getVersion(product);
    }

    public static String getVersionString() {
        return Version.getVersion(Product.PROJECT);
    }

    public static String getReleaseDate() {
        return releaseDate;
    }

    public static String getFVDLVersion() {
        return FVDL_VERSION;
    }

    public static String getFPRVersion() {
        return FPR_VERSION;
    }

    public static String getAuditreportVersion() {
        return AUDITREPORT_VERSION;
    }

    public static String getAttachmentsVersion() {
        return "1.1";
    }

    public static String getRulesFormatVersion() {
        return Version.getMajorMinorDotPatchVersion(Version.getVersion(Product.PROJECT));
    }

    public static String getRulesVersion() {
        return Version.getRulesFormatVersion();
    }

    public static int compareRulesFormatVersions(String thisVersion, String otherVersion) {
        return Version.compareVersions(thisVersion, otherVersion, Product.PROJECT);
    }

    public static String getMajorMinorPatchVersion(String version) {
        String majorminor;
        if (StringUtil.isEmpty(version)) {
            return version;
        }
        String[] parts = version.split("\\.");
        if (parts.length >= 2 && parts[1].length() == 2) {
            majorminor = parts[0] + "." + parts[1];
        } else if (parts.length >= 3 && parts[1].length() == 1 && parts[2].length() == 1) {
            majorminor = parts[0] + "." + parts[1] + parts[2];
        } else {
            majorminor = version;
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Version number in unexpected format: " + version);
        }
        return majorminor;
    }

    public static String getMajorMinorDotPatchVersion(String version) {
        String majorminor;
        if (StringUtil.isEmpty(version)) {
            return version;
        }
        String[] parts = version.split("\\.");
        if (parts.length >= 2 && parts[1].length() == 2) {
            majorminor = parts[0] + "." + parts[1].charAt(0) + "." + parts[1].charAt(1);
        } else if (parts.length >= 3 && parts[1].length() == 1 && parts[2].length() == 1) {
            majorminor = parts[0] + "." + parts[1] + "." + parts[2];
        } else {
            majorminor = version;
            logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Version number in unexpected format: " + version);
        }
        return majorminor;
    }

    public static String getExternalMetadataVersion() {
        return "1.1";
    }

    public static String getFilterTemplateVersion() {
        return FILTERTEMPLATE_VERSION;
    }

    public static int compareVersions(String thisVersion, String otherVersion, Product product) {
        Triple<Product, String, String> key = Triple.mk(product, thisVersion, otherVersion);
        Integer result = (Integer)cvCache.get(key);
        if (result == null) {
            result = Version.compareVersionsUncached(thisVersion, otherVersion, product);
            cvCache.putIfAbsent(key, result);
        }
        return result;
    }

    private static int compareVersionsUncached(String thisVersion, String otherVersion, Product product) {
        long otherMajor;
        long thisMajor;
        if (thisVersion == null || thisVersion.equals("")) {
            thisVersion = "0";
        }
        if (otherVersion == null || otherVersion.equals("")) {
            otherVersion = "0";
        }
        StringTokenizer thisTokens = new StringTokenizer(thisVersion, "\\.");
        StringTokenizer otherTokens = new StringTokenizer(otherVersion, "\\.");
        String thisTok0 = thisTokens.nextToken();
        String otherTok0 = otherTokens.nextToken();
        try {
            thisMajor = Long.parseLong(thisTok0);
            otherMajor = Long.parseLong(otherTok0);
        }
        catch (NumberFormatException nfe) {
            return Version.compareVersions(thisVersion, otherVersion);
        }
        if (thisMajor < otherMajor) {
            return -1;
        }
        if (thisMajor > otherMajor) {
            return 1;
        }
        if (thisMajor > (long)product.getLastOldStyleMajorVersion()) {
            String otherTok1;
            String thisTok1 = thisTokens.hasMoreTokens() ? thisTokens.nextToken() : "00";
            String string = otherTok1 = otherTokens.hasMoreTokens() ? otherTokens.nextToken() : "00";
            while (thisTokens.hasMoreTokens()) {
                thisTok1 = thisTok1 + thisTokens.nextToken();
            }
            while (otherTokens.hasMoreTokens()) {
                otherTok1 = otherTok1 + otherTokens.nextToken();
            }
            if (thisTok1.length() == 0) {
                thisTok1 = "00";
            } else if (thisTok1.length() == 1) {
                thisTok1 = thisTok1 + "0";
            }
            if (otherTok1.length() == 0) {
                otherTok1 = "00";
            } else if (otherTok1.length() == 1) {
                otherTok1 = otherTok1 + "0";
            }
            return thisTok1.compareTo(otherTok1);
        }
        return Version.compareVersions(thisVersion, otherVersion);
    }

    public static int compareVersions(String thisVersion, String otherVersion) {
        Triple<Object, String, String> key = Triple.mk(null, thisVersion, otherVersion);
        Integer result = (Integer)cvCache.get(key);
        if (result == null) {
            result = Version.compareVersionsUncached(thisVersion, otherVersion);
            cvCache.putIfAbsent(key, result);
        }
        return result;
    }

    private static int compareVersionsUncached(String thisVersion, String otherVersion) {
        if (thisVersion == null || thisVersion.equals("")) {
            thisVersion = "0";
        }
        StringTokenizer thisVerTokens = new StringTokenizer(thisVersion, "\\.");
        if (otherVersion == null || otherVersion.equals("")) {
            otherVersion = "0";
        }
        StringTokenizer otherVerTokens = new StringTokenizer(otherVersion, "\\.");
        return Version.compareTokenStreams(thisVerTokens, otherVerTokens, true);
    }

    private static int compareTokenStreams(StringTokenizer thisVerTokens, StringTokenizer otherVerTokens, boolean fallbackToUnderscore) {
        StringTokenizer checker;
        int possibleAnswer;
        int numComparableTokens = Math.min(otherVerTokens.countTokens(), thisVerTokens.countTokens());
        for (int i = 0; i < numComparableTokens; ++i) {
            String otherVerTokS;
            String thisVerTokS = thisVerTokens.nextToken();
            int tokenComparison = Version.compareTokens(thisVerTokS, otherVerTokS = otherVerTokens.nextToken(), fallbackToUnderscore);
            if (tokenComparison == 0) continue;
            return tokenComparison;
        }
        if (thisVerTokens.hasMoreTokens()) {
            possibleAnswer = 1;
            checker = thisVerTokens;
        } else {
            possibleAnswer = -1;
            checker = otherVerTokens;
        }
        while (checker.hasMoreTokens()) {
            try {
                if (Long.parseLong(checker.nextToken()) == 0L) continue;
                return possibleAnswer;
            }
            catch (NumberFormatException nfe) {
                return possibleAnswer;
            }
        }
        return 0;
    }

    private static int compareTokens(String thisVerTokS, String otherVerTokS, boolean fallbackToUnderscore) {
        Object otherVerTok;
        Object thisVerTok;
        if (fallbackToUnderscore && (thisVerTokS.indexOf("_") != -1 || otherVerTokS.indexOf("_") != -1)) {
            StringTokenizer thisSubtok = new StringTokenizer(thisVerTokS, "_");
            StringTokenizer otherSubtok = new StringTokenizer(otherVerTokS, "_");
            return Version.compareTokenStreams(thisSubtok, otherSubtok, false);
        }
        try {
            thisVerTok = new Long(thisVerTokS);
            otherVerTok = new Long(otherVerTokS);
        }
        catch (NumberFormatException e) {
            thisVerTok = thisVerTokS;
            otherVerTok = otherVerTokS;
        }
        int tokenComparison = thisVerTok.compareTo(otherVerTok);
        return tokenComparison;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadVersion(String versionResource) {
        String version;
        block6: {
            version = DEFAULT_VERSION;
            try {
                InputStream is;
                URL versionResourceUrl = Version.class.getClassLoader().getResource(versionResource);
                InputStream inputStream = is = versionResourceUrl != null ? versionResourceUrl.openStream() : null;
                if (is == null) break block6;
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = br.readLine();
                    if (line != null && line.length() > 0) {
                        version = line;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.log(ILoggerMin.Level.WARN, ILoggerMin.Marker.WARN_INTERNAL, "Exception reading version number", (Throwable)e);
            }
        }
        return version;
    }

    public static String extractVersionNumber(String source) {
        Matcher matcher = VERSION_PATTERN.matcher(source);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new IllegalArgumentException("No valid formatted version found");
    }

    public static class Product {
        private static int enumCount = 1;
        private int enumVal;
        private String name;
        private String version;
        private int lastOldStyleMajorVersion;
        public static final Product PROJECT = new Product("project", 3);
        public static final Product SCA = new Product("sca", 5);
        public static final Product SERVER = new Product("360server", 3);
        public static final Product RUNTIME = new Product("runtime", 4);
        public static final Product DEVINSPECT = new Product("devinspect", 1);

        private Product(String str, int lastOldStyleMajorVersion) {
            this.name = str;
            this.enumVal = enumCount++;
            if ("360server".equals(str)) {
                this.version = Version.loadVersion("version-ssc");
            }
            if (this.version == null || this.version.equals(DEFAULT_VERSION)) {
                this.version = Version.loadVersion("version-" + this.name);
            }
            this.lastOldStyleMajorVersion = lastOldStyleMajorVersion;
        }

        public String toString() {
            return this.name;
        }

        public int toInt() {
            return this.enumVal;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public int getLastOldStyleMajorVersion() {
            return this.lastOldStyleMajorVersion;
        }
    }
}

