/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util;

public class Base64 {
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private Base64() {
    }

    public static String encode(byte[] bytes) {
        int fullgroups = bytes.length / 3;
        int lastGroupSize = bytes.length % 3;
        char[] outbuf = new char[(fullgroups + (lastGroupSize > 0 ? 1 : 0)) * 4];
        int nextbyte = 0;
        int nextchar = 0;
        for (int i = 0; i < fullgroups; ++i) {
            int byte0 = bytes[nextbyte++] & 0xFF;
            int byte1 = bytes[nextbyte++] & 0xFF;
            int byte2 = bytes[nextbyte++] & 0xFF;
            outbuf[nextchar++] = chars[byte0 >> 2];
            outbuf[nextchar++] = chars[byte0 << 4 & 0x3F | byte1 >> 4];
            outbuf[nextchar++] = chars[byte1 << 2 & 0x3F | byte2 >> 6];
            outbuf[nextchar++] = chars[byte2 & 0x3F];
        }
        if (lastGroupSize != 0) {
            int byte0 = bytes[nextbyte++] & 0xFF;
            outbuf[nextchar++] = chars[byte0 >> 2];
            if (lastGroupSize == 1) {
                outbuf[nextchar++] = chars[byte0 << 4 & 0x3F];
                outbuf[nextchar++] = 61;
            } else {
                int byte1 = bytes[nextbyte++] & 0xFF;
                outbuf[nextchar++] = chars[byte0 << 4 & 0x3F | byte1 >> 4];
                outbuf[nextchar++] = chars[byte1 << 2 & 0x3F];
            }
            outbuf[nextchar++] = 61;
        }
        if (nextbyte != bytes.length) {
            throw new Error("Incorrect encoding: read " + nextbyte + " of " + bytes.length);
        }
        if (nextchar != outbuf.length) {
            throw new Error("Incorrect encoding: wrote " + nextchar + " of " + outbuf.length);
        }
        return new String(outbuf);
    }

    public static byte[] decode(String encoded) {
        int ngroups = encoded.length() / 4;
        if (ngroups * 4 != encoded.length()) {
            throw new IllegalArgumentException("Base64 encoded data must have a length that is a multiple of 4");
        }
        int fullGroups = ngroups;
        int bytesMissing = 0;
        if (encoded.charAt(encoded.length() - 1) == '=') {
            --fullGroups;
            bytesMissing = encoded.charAt(encoded.length() - 2) == '=' ? 2 : 1;
        }
        byte[] outbuf = new byte[ngroups * 3 - bytesMissing];
        int nextChar = 0;
        int nextByte = 0;
        for (int i = 0; i < fullGroups; ++i) {
            int c0 = Base64.charToInt(encoded.charAt(nextChar++));
            int c1 = Base64.charToInt(encoded.charAt(nextChar++));
            int c2 = Base64.charToInt(encoded.charAt(nextChar++));
            int c3 = Base64.charToInt(encoded.charAt(nextChar++));
            outbuf[nextByte++] = (byte)(c0 << 2 | c1 >> 4);
            outbuf[nextByte++] = (byte)(c1 << 4 | c2 >> 2);
            outbuf[nextByte++] = (byte)(c2 << 6 | c3);
        }
        if (bytesMissing != 0) {
            int c0 = Base64.charToInt(encoded.charAt(nextChar++));
            int c1 = Base64.charToInt(encoded.charAt(nextChar++));
            outbuf[nextByte++] = (byte)(c0 << 2 | c1 >> 4);
            if (bytesMissing == 1) {
                int c2 = Base64.charToInt(encoded.charAt(nextChar++));
                outbuf[nextByte++] = (byte)(c1 << 4 | c2 >> 2);
            } else {
                ++nextChar;
            }
            ++nextChar;
        }
        if (nextChar != encoded.length()) {
            throw new Error("Incorrect encoding: read " + nextChar + " of " + encoded.length());
        }
        if (nextByte != outbuf.length) {
            throw new Error("Incorrect encoding: wrote " + nextByte + " of " + outbuf.length);
        }
        return outbuf;
    }

    private static int charToInt(char c) {
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid character " + c + " in base64 data");
    }
}

